/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.emf.helpers.BundleResourceURIHelper;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BuildPropertiesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.PluginValidationService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers.ProfilePluginXMLValidator;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfilePluginChecker {
    private static final Set<String> ADDITIONAL_REQUIREMENTS = Set.of("org.eclipse.uml2.uml.resources");

    public static void checkProfilePlugin(IProject project, IProgressMonitor monitor) {
        Collection profileFiles = ProjectManagementService.getFilesFromProject((IContainer)project, (String)"profile.uml", (boolean)true);
        monitor.beginTask("Validate Profile plug-in", 1 + profileFiles.size() * 3);
        monitor.subTask("Prepare plug-in validation");
        MarkersService.deleteMarkers((IResource)project, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic");
        PluginValidationService pluginValidationService = new PluginValidationService();
        pluginValidationService.addPluginChecker((IPluginChecker)ProfilePluginChecker.createModelDependenciesChecker(project));
        for (IFile profileFile : profileFiles) {
            if (monitor.isCanceled()) {
                return;
            }
            URI profileFileURI = URI.createPlatformResourceURI((String)profileFile.getFullPath().toOSString(), (boolean)true);
            Resource resource = new ResourceSetImpl().getResource(profileFileURI, true);
            pluginValidationService.addPluginChecker((IPluginChecker)ProfilePluginChecker.createModelValidationChecker(project, profileFile, resource));
            pluginValidationService.addPluginChecker(ProfilePluginChecker.createExtensionsChecker(project, profileFile, resource));
            pluginValidationService.addPluginChecker((IPluginChecker)ProfilePluginChecker.createModelDependenciesChecker(project, profileFile, resource));
            pluginValidationService.addPluginChecker((IPluginChecker)ProfilePluginChecker.createBuildPropertiesChecker(project, profileFile, resource));
        }
        monitor.worked(1);
        pluginValidationService.validate(monitor);
    }

    public static IPluginChecker2.Factory modelDependenciesCheckerFactory() {
        return IPluginChecker2.Factory.forProject(ProfilePluginChecker::createModelDependenciesChecker).or(IPluginChecker2.Factory.forEMFResource(ProfilePluginChecker::createModelDependenciesChecker));
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project) {
        return new ModelDependenciesChecker(project, null, null, "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic").addRequirements(ADDITIONAL_REQUIREMENTS).withSeverityFunction(bundle -> ADDITIONAL_REQUIREMENTS.contains(bundle) ? 2 : 4);
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelDependenciesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic").withAdditionalRequirements(r -> ProfilePluginChecker.getBundlesFromExternalResources(r, project));
    }

    private static Collection<String> getBundlesFromExternalResources(Resource resource, IProject project) {
        EcoreUtil.resolveAll((Resource)resource);
        return resource.getResourceSet().getResources().stream().map(arg_0 -> ((BundleResourceURIHelper)BundleResourceURIHelper.INSTANCE).getBundleNameFromResource(arg_0)).filter(Objects::nonNull).filter(name -> !name.equals(project.getName())).collect(Collectors.toList());
    }

    public static IPluginChecker2.Factory modelValidationCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ProfilePluginChecker::createModelValidationChecker);
    }

    private static ModelValidationChecker createModelValidationChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelValidationChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic");
    }

    public static IPluginChecker2.Factory buildPropertiesCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ProfilePluginChecker::createBuildPropertiesChecker);
    }

    private static BuildPropertiesChecker createBuildPropertiesChecker(IProject project, IFile modelFile, Resource resource) {
        return new BuildPropertiesChecker(project, modelFile, "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic").withEMFGeneratorModels();
    }

    public static IPluginChecker2.Factory extensionsCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ProfilePluginChecker::createExtensionsChecker);
    }

    private static ExtensionsChecker<Profile, PluginErrorReporter<Profile>> createExtensionsChecker(IProject project, IFile modelFile, Resource resource) {
        Collection sets = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PROFILE);
        ArrayList<Profile> allProfiles = new ArrayList<Profile>();
        for (Profile profile : sets) {
            allProfiles.add(profile);
            allProfiles.addAll(PackageUtil.getSubProfiles((Package)profile));
        }
        return new ExtensionsChecker(project, modelFile, allProfiles, "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", ProfilePluginChecker::createPluginErrorReporter);
    }

    private static PluginErrorReporter<Profile> createPluginErrorReporter(IFile pluginXML, IFile modelFile, Profile model) {
        ProfilePluginXMLValidator validator = new ProfilePluginXMLValidator(modelFile);
        PluginErrorReporter reporter = new PluginErrorReporter(pluginXML, modelFile, (EObject)model, "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", profile -> profile.getName()).requireExtensionPoint("org.eclipse.emf.ecore.generated_package", validator::matchExtension, validator::checkExtension, validator::problemId).requireExtensionPoint("org.eclipse.uml2.uml.generated_package", validator::matchExtension, validator::checkExtension, validator::problemId);
        if (model.getNestingPackage() == null) {
            return reporter.softRequireExtensionPoint("org.eclipse.papyrus.uml.extensionpoints.UMLProfile", validator::matchExtension, validator::checkExtension, validator::problemId);
        }
        return reporter;
    }

    public static IPluginChecker2.Factory customModelCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ProfilePluginChecker::createCustomModelChecker);
    }

    private static CustomModelChecker createCustomModelChecker(IProject project, IFile modelFile, Resource resource) {
        return new CustomModelChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic");
    }
}

