/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.editor.palette.PaletteFactory;
import xpt.navigator.NavigatorItem;
import xpt.navigator.NavigatorLinkHelper;

@Singleton
@SuppressWarnings("all")
public class Editor {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private NavigatorLinkHelper xptNavigatorLinkHelper;
  
  @Inject
  private NavigatorItem xptNavigatorItem;
  
  @Inject
  private DiagramEditorContextMenuProvider xptDiagramEditorContextMenuProvider;
  
  @Inject
  private PaletteFactory pallette;
  
  public CharSequence className(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence packageName(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor");
    return _builder;
  }
  
  public CharSequence implementsList(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _implementsList = this.implementsList(this.buildImplementsList(it));
    _builder.append(_implementsList);
    return _builder;
  }
  
  public CharSequence implementsList(final Iterable<String> list) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEmpty = this._common_qvto.<String>notEmpty(list);
      if (_notEmpty) {
        _builder.append("implements ");
        {
          boolean _hasElements = false;
          for(final String next : list) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            _builder.append(next);
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence Editor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _contextID = this.getContextID(it);
    _builder.append(_contextID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      Palette _palette = it.getEditorGen().getDiagram().getPalette();
      boolean _notEquals = (!Objects.equal(_palette, null));
      if (_notEquals) {
        _builder.append("\t");
        CharSequence _createPaletteRoot = this.createPaletteRoot(it.getEditorGen().getDiagram().getPalette());
        _builder.append(_createPaletteRoot, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _preferencesHint = this.getPreferencesHint(it);
    _builder.append(_preferencesHint, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _contributorId = this.getContributorId(it);
    _builder.append(_contributorId, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _adapter = this.getAdapter(it);
    _builder.append(_adapter, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _documentProvider = this.getDocumentProvider(it);
    _builder.append(_documentProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _editingDomain = this.getEditingDomain(it);
    _builder.append(_editingDomain, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setDocumentProvider = this.setDocumentProvider(it);
    _builder.append(_setDocumentProvider, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _isIDEMode = this.isIDEMode(it);
      if (_isIDEMode) {
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _gotoMarker = this.gotoMarker(it);
        _builder.append(_gotoMarker, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _isSaveAsAllowed = this.isSaveAsAllowed(it);
        _builder.append(_isSaveAsAllowed, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _doSaveAs = this.doSaveAs(it);
        _builder.append(_doSaveAs, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _performSaveAs = this.performSaveAs(it);
        _builder.append(_performSaveAs, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _showInContext = this.getShowInContext(it);
        _builder.append(_showInContext, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        {
          boolean _hasNavigator = this.hasNavigator(it);
          if (_hasNavigator) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _navigatorSelection = this.getNavigatorSelection(it.getEditorGen().getNavigator());
            _builder.append(_navigatorSelection, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _configureGraphicalViewer = this.configureGraphicalViewer(it);
    _builder.append(_configureGraphicalViewer, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _generateCreateShortcutAction = it.getEditorGen().getDiagram().generateCreateShortcutAction();
      if (_generateCreateShortcutAction) {
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _initializeGraphicalViewer = this.initializeGraphicalViewer(it);
        _builder.append(_initializeGraphicalViewer, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _controlLastClickPositionProviderService = this.controlLastClickPositionProviderService(it);
        _builder.append(_controlLastClickPositionProviderService, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _dispose = this.dispose(it);
        _builder.append(_dispose, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _DropTargetListener = this.DropTargetListener(it);
        _builder.append(_DropTargetListener, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence attributes(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static final String ID = \"");
    String _iD = it.getID();
    _builder.append(_iD, "\t");
    _builder.append("\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static final String CONTEXT_ID = \"");
    String _contextID = it.getContextID();
    _builder.append(_contextID, "\t");
    _builder.append("\"; ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      boolean _generateCreateShortcutAction = it.getEditorGen().getDiagram().generateCreateShortcutAction();
      if (_generateCreateShortcutAction) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.gmf.tooling.runtime.part.LastClickPositionProvider myLastClickPositionProvider;");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence constructor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(");
    _builder.append(((!Objects.equal(null, it.getEditorGen().getDiagram().getPalette())) && it.getEditorGen().getDiagram().getPalette().isFlyout()), "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getContextID(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected String getContextID() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return CONTEXT_ID;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createPaletteRoot(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.palette.PaletteRoot createPaletteRoot(org.eclipse.gef.palette.PaletteRoot existingPaletteRoot) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gef.palette.PaletteRoot root = super.createPaletteRoot(existingPaletteRoot);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("new ");
    CharSequence _qualifiedClassName = this.pallette.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append("().fillPalette(root);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return root;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getPreferencesHint(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint getPreferencesHint() {");
    _builder.newLine();
    _builder.append("return ");
    CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
    _builder.append(_preferenceHintAccess);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getContributorId(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getContributorId() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".ID;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAdapter(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!this.hasPropertySheet(it)) || this.hasNavigator(it))) {
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("@SuppressWarnings(\"rawtypes\")");
        _builder.newLine();
        _builder.append("public Object getAdapter(Class type) {");
        _builder.newLine();
        {
          boolean _hasPropertySheet = this.hasPropertySheet(it);
          boolean _not = (!_hasPropertySheet);
          if (_not) {
            _builder.append("\t");
            _builder.append("if (type == org.eclipse.ui.views.properties.IPropertySheetPage.class) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        {
          boolean _hasNavigator = this.hasNavigator(it);
          if (_hasNavigator) {
            _builder.append("\t");
            _builder.append("if (type == org.eclipse.ui.part.IShowInTargetList.class) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return new org.eclipse.ui.part.IShowInTargetList() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("public String[] getShowInTargetIds() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("return new String[] { org.eclipse.ui.navigator.resources.ProjectExplorer.VIEW_ID };");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("return super.getAdapter(type);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence getDocumentProvider(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider getDocumentProvider(org.eclipse.ui.IEditorInput input) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _checkEditorInput = this.checkEditorInput(it);
    _builder.append(_checkEditorInput, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().getDocumentProvider();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getDocumentProvider(input);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getEditingDomain(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.transaction.TransactionalEditingDomain getEditingDomain() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document = getEditorInput() != null ? getDocumentProvider().getDocument(getEditorInput()) : null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (document instanceof org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ((org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) document).getEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getEditingDomain();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setDocumentProvider(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setDocumentProvider(org.eclipse.ui.IEditorInput input) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _checkEditorInput = this.checkEditorInput(it);
    _builder.append(_checkEditorInput, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("setDocumentProvider(");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().getDocumentProvider());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.setDocumentProvider(input);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence checkEditorInput(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isIDEMode = this.isIDEMode(it);
      if (_isIDEMode) {
        _builder.append("input instanceof org.eclipse.ui.IFileEditorInput || ");
      }
    }
    _builder.append("input instanceof org.eclipse.emf.common.ui.URIEditorInput");
    return _builder;
  }
  
  public CharSequence gotoMarker(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void gotoMarker(org.eclipse.core.resources.IMarker marker) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService.getInstance().gotoMarker(this, marker);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isSaveAsAllowed(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isSaveAsAllowed() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doSaveAs(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void doSaveAs() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("performSaveAs(new org.eclipse.core.runtime.NullProgressMonitor());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence performSaveAs(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void performSaveAs(org.eclipse.core.runtime.IProgressMonitor progressMonitor) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.widgets.Shell shell = getSite().getShell();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IEditorInput input = getEditorInput();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.dialogs.SaveAsDialog dialog = new org.eclipse.ui.dialogs.SaveAsDialog(shell);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.resources.IFile original = input instanceof org.eclipse.ui.IFileEditorInput ? ((org.eclipse.ui.IFileEditorInput) input).getFile() : null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (original != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dialog.setOriginalFile(original);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dialog.create();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider provider = getDocumentProvider();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (provider == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// editor has been programmatically closed while the dialog was open");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (provider.isDeleted(input) && original != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String message = org.eclipse.osgi.util.NLS.bind(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this.i18nKeyForSavingDeletedFile(it));
    _builder.append(_accessorCall, "\t\t");
    _builder.append(", original.getName());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("dialog.setErrorMessage(null);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dialog.setMessage(message, org.eclipse.jface.dialogs.IMessageProvider.WARNING);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (dialog.open() == org.eclipse.jface.window.Window.CANCEL) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (progressMonitor != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("progressMonitor.setCanceled(true);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.runtime.IPath filePath = dialog.getResult();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (filePath == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (progressMonitor != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("progressMonitor.setCanceled(true);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.resources.IWorkspaceRoot workspaceRoot = org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRoot();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.resources.IFile file = workspaceRoot.getFile(filePath);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.ui.IEditorInput newInput = new org.eclipse.ui.part.FileEditorInput(file);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Check if the editor is already open");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IEditorMatchingStrategy matchingStrategy = getEditorDescriptor().getEditorMatchingStrategy();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IEditorReference[] editorRefs = org.eclipse.ui.PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (int i = 0; i < editorRefs.length; i++) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (matchingStrategy.matches(editorRefs[i], newInput)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.jface.dialogs.MessageDialog.openWarning(shell, ");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveAsProblems(it)));
    _builder.append(_accessorCall_1, "\t\t\t");
    _builder.append(", ");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveAsProblems(it)));
    _builder.append(_accessorCall_2, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("boolean success = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("provider.aboutToChange(newInput);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getDocumentProvider(newInput).saveDocument(progressMonitor, newInput, getDocumentProvider().getDocument(getEditorInput()), true);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("success = true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (org.eclipse.core.runtime.CoreException x) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IStatus status = x.getStatus();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (status == null || status.getSeverity() != org.eclipse.core.runtime.IStatus.CANCEL) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.jface.dialogs.ErrorDialog.openError(shell, ");
    CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveProblems(it)));
    _builder.append(_accessorCall_3, "\t\t\t");
    _builder.append(", ");
    CharSequence _accessorCall_4 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveProblems(it)));
    _builder.append(_accessorCall_4, "\t\t\t");
    _builder.append(", x.getStatus());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} finally {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("provider.changed(newInput);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (success) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setInput(newInput);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (progressMonitor != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("progressMonitor.setCanceled(!success);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getShowInContext(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.ui.part.ShowInContext getShowInContext() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.ui.part.ShowInContext(getEditorInput(), ");
    {
      boolean _hasNavigator = this.hasNavigator(it);
      if (_hasNavigator) {
        _builder.append("getNavigatorSelection()");
      } else {
        _builder.append("getGraphicalViewer().getSelection()");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getNavigatorSelection(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.jface.viewers.ISelection getNavigatorSelection() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document = getDiagramDocument();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _findSelectionBody = this.xptNavigatorLinkHelper.findSelectionBody(it);
    _builder.append(_findSelectionBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence configureGraphicalViewer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void configureGraphicalViewer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.configureGraphicalViewer();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptDiagramEditorContextMenuProvider.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" provider =");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("new ");
    CharSequence _qualifiedClassName_1 = this.xptDiagramEditorContextMenuProvider.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t\t\t");
    _builder.append("(this, getDiagramGraphicalViewer());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("getDiagramGraphicalViewer().setContextMenu(provider);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getSite().registerContextMenu(org.eclipse.gmf.runtime.diagram.ui.actions.ActionIds.DIAGRAM_EDITOR_CONTEXT_MENU, provider, getDiagramGraphicalViewer());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence initializeGraphicalViewer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void initializeGraphicalViewer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.initializeGraphicalViewer();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _addDropTargetListener = this.addDropTargetListener(it, "org.eclipse.jface.util.LocalSelectionTransfer.getTransfer()");
    _builder.append(_addDropTargetListener, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _addDropTargetListener_1 = this.addDropTargetListener(it, "org.eclipse.emf.edit.ui.dnd.LocalTransfer.getInstance()");
    _builder.append(_addDropTargetListener_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("startupLastClickPositionProvider();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence controlLastClickPositionProviderService(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void startupLastClickPositionProvider() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (myLastClickPositionProvider == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider = new org.eclipse.gmf.tooling.runtime.part.LastClickPositionProvider(this);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider.attachToService();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void shutDownLastClickPositionProvider() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (myLastClickPositionProvider != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider.detachFromService();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider.dispose();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence dispose(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it.getEditorGen().getDiagram());
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void dispose() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("shutDownLastClickPositionProvider();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.dispose();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addDropTargetListener(final GenEditorView it, final String transferAccessor) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getDiagramGraphicalViewer().addDropTargetListener(new DropTargetListener(getDiagramGraphicalViewer(), ");
    _builder.append(transferAccessor);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected Object getJavaObject(org.eclipse.swt.dnd.TransferData data) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    _builder.append(transferAccessor, "\t\t");
    _builder.append(".nativeToJava(data);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("});");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DropTargetListener(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private abstract class DropTargetListener extends org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _DTL_constructor = this.DTL_constructor(it);
    _builder.append(_DTL_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _DTL_getObjectsBeingDropped = this.DTL_getObjectsBeingDropped(it);
    _builder.append(_DTL_getObjectsBeingDropped, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _DTL_getJavaObject = this.DTL_getJavaObject(it);
    _builder.append(_DTL_getJavaObject, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _DTL_additions = this.DTL_additions(it);
    _builder.append(_DTL_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DTL_constructor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public DropTargetListener(org.eclipse.gef.EditPartViewer viewer, org.eclipse.swt.dnd.Transfer xfer) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super(viewer, xfer);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DTL_getObjectsBeingDropped(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("protected java.util.List getObjectsBeingDropped() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.dnd.TransferData data = getCurrentEvent().currentDataType;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.HashSet<org.eclipse.emf.common.util.URI> uris = new java.util.HashSet<org.eclipse.emf.common.util.URI>(); ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object transferedObject = getJavaObject(data);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (transferedObject instanceof org.eclipse.jface.viewers.IStructuredSelection) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.viewers.IStructuredSelection selection = (org.eclipse.jface.viewers.IStructuredSelection) transferedObject;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<?> it = selection.iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Object nextSelectedObject = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    {
      boolean _hasNavigator = this.hasNavigator(it);
      if (_hasNavigator) {
        _builder.append("if (nextSelectedObject instanceof ");
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it.getEditorGen().getNavigator());
        _builder.append(_qualifiedClassName, "\t\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t\t\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = ((");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it.getEditorGen().getNavigator());
        _builder.append(_qualifiedClassName_1, "\t\t\t\t\t\t\t\t");
        _builder.append(") nextSelectedObject).getView();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t\t\t\t\t");
        _builder.append("nextSelectedObject = view.getElement();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else ");
      }
    }
    _builder.append("if (nextSelectedObject instanceof org.eclipse.core.runtime.IAdaptable) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.core.runtime.IAdaptable adaptable = (org.eclipse.core.runtime.IAdaptable) nextSelectedObject;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("nextSelectedObject = adaptable.getAdapter(org.eclipse.emf.ecore.EObject.class);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (nextSelectedObject instanceof org.eclipse.emf.ecore.EObject) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject modelElement = (org.eclipse.emf.ecore.EObject) nextSelectedObject;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("uris.add(org.eclipse.emf.ecore.util.EcoreUtil.getURI(modelElement));\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.ArrayList<org.eclipse.emf.ecore.EObject> result = new java.util.ArrayList<org.eclipse.emf.ecore.EObject>(uris.size());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (org.eclipse.emf.common.util.URI nextURI : uris) { ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject modelObject = getEditingDomain().getResourceSet().getEObject(nextURI, true);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("result.add(modelObject);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DTL_getJavaObject(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("protected abstract Object getJavaObject(org.eclipse.swt.dnd.TransferData data);");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DTL_additions(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence additions(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nValues(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForSavingDeletedFile(it), "The original file \"{0}\" has been deleted.");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveAsProblems(it)), "Problem During Save As...");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveAsProblems(it)), 
      "Save could not be completed. Target file is already open in another editor.");
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveProblems(it)), "Save Problems");
    _builder.append(_messageEntry_3);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveProblems(it)), "Could not save file.");
    _builder.append(_messageEntry_4);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nAccessors(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForSavingDeletedFile(it));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveAsProblems(it)));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveAsProblems(it)));
    _builder.append(_accessorField_2);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveProblems(it)));
    _builder.append(_accessorField_3);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_4 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveProblems(it)));
    _builder.append(_accessorField_4);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public String i18nKeyForSavingDeletedFile(final GenEditorView editor) {
    String _i18nKeyForEditor = this.i18nKeyForEditor(editor);
    return (_i18nKeyForEditor + ".SavingDeletedFile");
  }
  
  @Localization
  public String i18nKeyForSaveAsProblems(final GenEditorView editor) {
    String _i18nKeyForEditor = this.i18nKeyForEditor(editor);
    return (_i18nKeyForEditor + ".SaveAsError");
  }
  
  @Localization
  public String i18nKeyForSaveProblems(final GenEditorView editor) {
    String _i18nKeyForEditor = this.i18nKeyForEditor(editor);
    return (_i18nKeyForEditor + ".SaveError");
  }
  
  @Localization
  public String i18nKeyForEditor(final GenEditorView editor) {
    CharSequence _className = this.className(editor);
    return ("" + _className);
  }
  
  public Iterable<String> buildImplementsList(final GenEditorView it) {
    List<String> result = CollectionLiterals.<String>newLinkedList();
    boolean _isIDEMode = this.isIDEMode(it);
    if (_isIDEMode) {
      result.add("org.eclipse.ui.ide.IGotoMarker");
    }
    if ((this.hasPropertySheet(it) && it.getEditorGen().getPropertySheet().isReadOnly())) {
      result.add(
        "org.eclipse.gmf.runtime.diagram.ui.properties.views.IReadOnlyDiagramPropertySheetPageContributor");
    }
    return result;
  }
  
  public boolean isIDEMode(final GenEditorView it) {
    GenApplication _application = it.getEditorGen().getApplication();
    return Objects.equal(null, _application);
  }
  
  public boolean hasPropertySheet(final GenEditorView it) {
    GenPropertySheet _propertySheet = it.getEditorGen().getPropertySheet();
    return (!Objects.equal(_propertySheet, null));
  }
  
  public boolean hasNavigator(final GenEditorView it) {
    GenNavigator _navigator = it.getEditorGen().getNavigator();
    return (!Objects.equal(_navigator, null));
  }
}
