/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.handler;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies.HyperlinkNavigationMenuEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateHyperlinkedTableHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EditPolicy editPolicy = this.getEditPolicy("org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationEditPolicy");
        if (editPolicy instanceof HyperlinkNavigationMenuEditPolicy) {
            HyperlinkNavigationMenuEditPolicy hyperlinkNavigationMenuEditPolicy = (HyperlinkNavigationMenuEditPolicy)editPolicy;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                EObject selectedElement = EMFHelper.getEObject((Object)structuredSelection.getFirstElement());
                ArrayList<ViewPrototype> tablePrototypes = new ArrayList<ViewPrototype>();
                for (ViewPrototype proto : PolicyChecker.getFor((EObject)selectedElement).getPrototypesFor(selectedElement)) {
                    if (!(proto.getRepresentationKind() instanceof PapyrusTable)) continue;
                    tablePrototypes.add(proto);
                }
                if (!tablePrototypes.isEmpty()) {
                    Collections.sort(tablePrototypes, new ViewPrototype.Comp());
                    HyperlinkNavigationMenuEditPolicy hyperlinkNavigationMenuEditPolicy2 = hyperlinkNavigationMenuEditPolicy;
                    ((Object)((Object)hyperlinkNavigationMenuEditPolicy2)).getClass();
                    HyperlinkNavigationMenuEditPolicy.AddViewPopupAction addTableAction = new HyperlinkNavigationMenuEditPolicy.AddViewPopupAction(hyperlinkNavigationMenuEditPolicy2, tablePrototypes, Messages.HyperlinkNavigationMenuEditPolicy_CreateTableDialogTitle, Messages.HyperlinkNavigationMenuEditPolicy_CreateTableDialogMessage);
                    addTableAction.run();
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private EditPolicy getEditPolicy(String editPolicyName) {
        ISelectionService selectionService;
        ISelection selectionTmp;
        EditPolicy lookupEditPolicy = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (selectionTmp = (selectionService = activeWorkbenchWindow.getSelectionService()).getSelection()) != null && !selectionTmp.isEmpty() && selectionTmp instanceof StructuredSelection) {
            for (Object current : (StructuredSelection)selectionTmp) {
                EditPolicy editpolicy;
                if (!(current instanceof IGraphicalEditPart) || (editpolicy = ((IGraphicalEditPart)current).getEditPolicy((Object)editPolicyName)) == null) continue;
                lookupEditPolicy = editpolicy;
                break;
            }
        }
        return lookupEditPolicy;
    }
}

