/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainerChangedListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class SashWindowsEventsProvider {
    private PageChangedListeners pageEventsManager = new PageChangedListeners();
    private SashWindowsContainerChangedListeners containerEventsManager = new SashWindowsContainerChangedListeners();
    private IWorkbenchPage workbenchPage;
    private IEditorPart lastActiveEditor = null;
    private ISashWindowsContainer currentContainer = null;
    private IPage activePage = null;
    private IPartListener workbenchPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            SashWindowsEventsProvider.this.checkActiveEditorChange();
        }
    };
    private IPageChangedListener sashPageChangedListener = new IPageChangedListener(){

        @Override
        public void pageChanged(IPage newPage) {
            SashWindowsEventsProvider.this.firePageChanged(newPage);
        }
    };

    public SashWindowsEventsProvider(IWorkbenchPage page) {
        this.init(page);
        this.registerEditorChangedListener();
        this.checkActiveEditorChange();
    }

    private void init(IWorkbenchPage page) {
        if (page == null) {
            throw new IllegalArgumentException("page should not be null.");
        }
        this.workbenchPage = page;
    }

    public ISashWindowsContainer activeSashWindowsContainer() {
        return this.currentContainer;
    }

    public IEditorPart activeSashWindowsContainerOwner() {
        if (this.currentContainer == null) {
            return null;
        }
        return this.workbenchPage.getActiveEditor();
    }

    public IPage activeSashWindowsPage() {
        return this.activePage;
    }

    private void checkActiveEditorChange() {
        IEditorPart editor = this.workbenchPage.getActiveEditor();
        if (editor != this.lastActiveEditor) {
            this.lastActiveEditor = editor;
            this.activeEditorChanged(editor);
        }
        this.lastActiveEditor = editor;
    }

    public void dispose() {
        this.workbenchPage.removePartListener(this.workbenchPartListener);
    }

    private void registerEditorChangedListener() {
        this.workbenchPage.addPartListener(this.workbenchPartListener);
    }

    private void activeEditorChanged(IEditorPart newEditor) {
        ISashWindowsContainer newContainer = null;
        if (newEditor != null) {
            newContainer = (ISashWindowsContainer)newEditor.getAdapter(ISashWindowsContainer.class);
        }
        if (newContainer != this.currentContainer) {
            this.activeContainerChanged(newContainer);
        }
    }

    private void activeContainerChanged(ISashWindowsContainer newContainer) {
        if (this.currentContainer != null && !this.currentContainer.isDisposed()) {
            this.currentContainer.removePageChangedListener(this.sashPageChangedListener);
        }
        this.currentContainer = newContainer;
        if (this.currentContainer != null) {
            this.currentContainer.addPageChangedListener(this.sashPageChangedListener);
            this.firePageChanged(newContainer.getActiveSashWindowsPage());
        }
        this.fireContainerChanged(newContainer);
        IPage newPage = newContainer != null ? newContainer.getActiveSashWindowsPage() : null;
        this.firePageChanged(newPage);
    }

    private void fireContainerChanged(ISashWindowsContainer newContainer) {
        this.containerEventsManager.fireEvent(newContainer);
    }

    private void firePageChanged(IPage newPage) {
        this.activePage = newPage;
        this.pageEventsManager.fireEvent(newPage);
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageEventsManager.addListener(listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageEventsManager.removeListener(listener);
    }

    public void addSashWindowsContainerChangedListener(ISashWindowsContainerChangedListener listener) {
        this.containerEventsManager.addListener(listener);
    }

    public void removeSashWindowsContainerChangedListener(ISashWindowsContainerChangedListener listener) {
        this.containerEventsManager.removeListener(listener);
    }

    private abstract class ListenersList<Listener, Event> {
        List<Listener> listeners;

        private ListenersList() {
        }

        public void addListener(Listener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<Listener>();
            }
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removeListener(Listener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public void fireEvent(Event event) {
            if (this.listeners == null) {
                return;
            }
            for (Listener listener : this.listeners) {
                this.propertyChanged(listener, event);
            }
        }

        public abstract void propertyChanged(Listener var1, Event var2);
    }

    public class PageChangedListeners
    extends ListenersList<IPageChangedListener, IPage> {
        @Override
        public void propertyChanged(IPageChangedListener listener, IPage newPage) {
            try {
                listener.pageChanged(newPage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class SashWindowsContainerChangedListeners
    extends ListenersList<ISashWindowsContainerChangedListener, ISashWindowsContainer> {
        @Override
        public void propertyChanged(ISashWindowsContainerChangedListener listener, ISashWindowsContainer newContainer) {
            listener.sashWindowsContainerChanged(newContainer);
        }
    }
}

