/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class UnicodeCaseInsensitiveTextSearchStrategy
implements TextSearchStrategy {
    private static final RuleBasedCollator COLLATOR = (RuleBasedCollator)Collator.getInstance();
    private String pattern;
    private final int mode;

    public UnicodeCaseInsensitiveTextSearchStrategy(int mode) {
        this.mode = mode;
    }

    public void setCharacterMap(char[] charMap) {
        throw new UnsupportedOperationException("character maps are not supported by the UnicodeCaseInsensitiveTextSearchStrategy");
    }

    public void setSubtext(String subtext) {
        this.pattern = subtext;
    }

    public int indexOf(String text) {
        if (this.pattern == null) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        if (text.length() == 0) {
            return -1;
        }
        int index = new StringSearch(this.pattern, (CharacterIterator)new StringCharacterIterator(text), COLLATOR).first();
        return this.mode == 1 && index != 0 ? -1 : index;
    }

    static {
        COLLATOR.setStrength(0);
    }
}

