/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.mode.AbstractModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.nebula.widgets.nattable.ui.mode.MouseModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.util.MouseEventHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseEvent;

public class DragModeEventHandler
extends AbstractModeEventHandler {
    private final IDragMode dragMode;
    private final MouseModeEventHandler parentModeEventHandler;
    private final MouseEvent mouseDownEvent;
    private boolean realDrag = false;

    public DragModeEventHandler(ModeSupport modeSupport, NatTable natTable, IDragMode dragMode, MouseModeEventHandler parentModeEventHandler, MouseEvent mouseDownEvent) {
        super(modeSupport, natTable);
        this.dragMode = dragMode;
        this.parentModeEventHandler = parentModeEventHandler;
        this.mouseDownEvent = mouseDownEvent;
    }

    @Override
    public void mouseMove(MouseEvent event) {
        this.dragMode.mouseMove(this.natTable, event);
        if (!this.realDrag && !MouseEventHelper.treatAsClick(this.mouseDownEvent, event)) {
            this.realDrag = true;
        }
    }

    @Override
    public void mouseUp(MouseEvent event) {
        this.dragMode.mouseUp(this.natTable, event);
        this.switchMode("NORMAL_MODE");
        if (!this.realDrag && MouseEventHelper.eventOnSameCell(this.natTable, this.mouseDownEvent, event)) {
            this.parentModeEventHandler.mouseUp(event);
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.mouseUp(this.mouseDownEvent);
    }
}

