/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.GetObjectsOfTypeListSelectionDialog;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.actions.LabelHelper;
import org.eclipse.papyrus.uml.diagram.common.ui.helper.HelpComponentFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateParameterDialog
extends FormDialog {
    private Text creationNameText;
    private Text creationTypeText;
    private Button creationTypeButton;
    private Parameter createdParameter = null;
    private EObject selectedType = null;
    private NamedElement parameterOwner;
    private String selectedName = null;
    private ParameterDirectionKind selectedDirection = null;
    private ComboViewer directionComboViewer = null;
    private Combo creationDirectionCombo = null;
    private ILabelProvider labelProvider;
    private ParameterDirectionKind defaultDirection = null;

    public CreateParameterDialog(Shell shell, NamedElement owner, ParameterDirectionKind defaultDirectionKind) {
        super(shell);
        this.parameterOwner = owner;
        this.labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
        this.defaultDirection = defaultDirectionKind;
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText(this.getTitle());
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createParameterSection(scrolledForm.getBody(), toolkit);
        this.hookListeners();
        this.setInvokedName(null);
        scrolledForm.reflow(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshOkButton();
    }

    protected void createParameterSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = this.getCreationTitle();
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ImageHyperlink componentHelp = HelpComponentFactory.createHelpComponent((Composite)lSection, (FormToolkit)pToolkit, (String)CustomMessages.CreateParameterDialog_ParameterCreationHelp, (boolean)true);
        lSection.setTextClient((Control)componentHelp);
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        pToolkit.createLabel(lBody, this.getNameLabel(), 0);
        this.creationNameText = pToolkit.createText(lBody, "", 2048);
        this.creationNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.creationNameText.setFocus();
        pToolkit.createLabel(lBody, this.getTypeLabel(), 0);
        this.creationTypeText = pToolkit.createText(lBody, this.labelProvider.getText((Object)this.selectedType), 2056);
        this.creationTypeText.setLayoutData((Object)new GridData(768));
        this.creationTypeButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = this.getTypeImage();
        this.creationTypeButton.setImage(image);
        this.creationTypeButton.setLayoutData((Object)new GridData(0));
        pToolkit.createLabel(lBody, this.getDirectionLabel(), 0);
        this.creationDirectionCombo = new Combo(lBody, 12);
        this.directionComboViewer = new ComboViewer(this.creationDirectionCombo);
        pToolkit.adapt((Composite)this.creationDirectionCombo);
        this.creationDirectionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.directionComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.directionComboViewer.add((Object[])this.getPossibleDirections());
        this.directionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getDefaultDirection()));
        this.selectedDirection = ParameterDirectionKind.getByName((String)this.getDefaultDirection());
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        this.createdParameter = UMLFactory.eINSTANCE.createParameter();
        this.createdParameter.setName(this.selectedName);
        this.createdParameter.setType((Type)this.selectedType);
        this.createdParameter.setDirection(this.selectedDirection);
        this.addParameter(this.createdParameter);
        super.okPressed();
    }

    public Parameter getCreatedParameter() {
        return this.createdParameter;
    }

    private void hookListeners() {
        if (this.creationDirectionCombo != null && this.directionComboViewer != null) {
            ModifyListener lTypeListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ISelection sel = CreateParameterDialog.this.directionComboViewer.getSelection();
                    if (sel instanceof StructuredSelection) {
                        String firstElement = ((StructuredSelection)sel).getFirstElement().toString();
                        CreateParameterDialog.this.selectedDirection = ParameterDirectionKind.getByName((String)firstElement);
                    } else {
                        CreateParameterDialog.this.selectedDirection = null;
                    }
                    CreateParameterDialog.this.setInvokedName(null);
                    CreateParameterDialog.this.refreshOkButton();
                }
            };
            this.creationDirectionCombo.addModifyListener(lTypeListener);
        }
        ModifyListener lNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateParameterDialog.this.setInvokedName(CreateParameterDialog.this.creationNameText.getText());
            }
        };
        this.creationNameText.addModifyListener(lNameListener);
        SelectionAdapter selectParentBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateParameterDialog.this.handleChooseType();
                if (CreateParameterDialog.this.selectedName == null) {
                    CreateParameterDialog.this.setInvokedName(null);
                }
                CreateParameterDialog.this.refreshOkButton();
            }
        };
        this.creationTypeButton.addSelectionListener((SelectionListener)selectParentBtnListener);
    }

    private void setInvokedName(String text) {
        String name = text;
        if (text == null) {
            name = LabelHelper.INSTANCE.findName((EObject)this.parameterOwner, UMLPackage.eINSTANCE.getParameter());
            this.creationNameText.setText(name);
        } else if (name != null && !"".equals(name.trim())) {
            this.selectedName = name.trim();
            Color black = this.creationNameText.getDisplay().getSystemColor(2);
            this.creationNameText.setForeground(black);
            this.refreshOkButton();
        } else {
            this.selectedName = null;
            Color red = this.creationNameText.getDisplay().getSystemColor(3);
            this.creationNameText.setForeground(red);
            this.refreshOkButton();
        }
    }

    private void handleChooseType() {
        GetObjectsOfTypeListSelectionDialog dialog = new GetObjectsOfTypeListSelectionDialog(this.getShell(), this.labelProvider, (EObject)this.parameterOwner, true);
        dialog.addElementsOfType(UMLPackage.eINSTANCE.getTypedElement_Type().getEType());
        if (dialog.open() == 0) {
            Object firstResult = dialog.getFirstResult();
            if (firstResult instanceof EObject) {
                this.setType((EObject)dialog.getFirstResult());
            } else {
                this.setType(null);
            }
        }
    }

    private void setType(EObject type) {
        this.selectedType = type;
        if (this.selectedType instanceof NamedElement) {
            this.creationTypeText.setText(this.labelProvider.getText((Object)this.selectedType));
        } else {
            this.creationTypeText.setText("");
        }
    }

    private void refreshOkButton() {
        if (this.getButton(0) != null && !this.getButton(0).isDisposed()) {
            this.getButton(0).setEnabled(this.selectedDirection != null && this.selectedName != null);
        }
    }

    protected void addParameter(Parameter createdParameter) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        Command addCmd = AddCommand.create((EditingDomain)editingdomain, (Object)this.parameterOwner, null, Collections.singleton(createdParameter));
        addCmd.execute();
    }

    private String[] getPossibleDirections() {
        List values = ParameterDirectionKind.VALUES;
        String[] ret = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            ret[i] = ((ParameterDirectionKind)values.get(i)).getName();
            ++i;
        }
        return ret;
    }

    private String getDefaultDirection() {
        if (this.defaultDirection != null) {
            return this.defaultDirection.getName();
        }
        return this.getPossibleDirections()[0];
    }

    private Image getTypeImage() {
        return UMLElementTypes.getImage((ENamedElement)UMLPackage.eINSTANCE.getPackage_PackagedElement());
    }

    private String getTitle() {
        return CustomMessages.CreateParameterDialog_DialogTitle;
    }

    private String getCreationTitle() {
        return CustomMessages.CreateParameterDialog_ParameterCreationTitle;
    }

    private String getNameLabel() {
        return CustomMessages.CreateParameterDialog_NameLabel;
    }

    private String getTypeLabel() {
        return CustomMessages.CreateParameterDialog_TypeLabel;
    }

    private String getDirectionLabel() {
        return CustomMessages.CreateParameterDialog_DirectionLabel;
    }
}

