/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.dom;

import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.GMFElementAdapter;

public class StyleListener
extends AdapterImpl {
    private final GMFElementAdapter elementAdapter;

    public StyleListener(GMFElementAdapter elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    public void notifyChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        if (notification.getFeature() == NotationPackage.eINSTANCE.getView_Element()) {
            if (notification.getNewValue() == null) {
                this.elementAdapter.notationElementDisposed();
            } else {
                this.elementAdapter.semanticElementChanged();
            }
            return;
        }
        if (notification.getNotifier() == this.elementAdapter.getNotationElement()) {
            EReference reference;
            if (this.shouldPropagateNotationEvent(notification)) {
                this.elementAdapter.notationPropertyChanged();
            }
            if (notification.getFeature() instanceof EReference && (reference = (EReference)notification.getFeature()).getEContainingClass() == NotationPackage.Literals.VIEW) {
                switch (notification.getFeatureID(View.class)) {
                    case 6: 
                    case 10: {
                        Stream<Object> changedViews;
                        this.elementAdapter.childrenChanged();
                        switch (notification.getEventType()) {
                            case 3: {
                                changedViews = Stream.of(notification.getNewValue());
                                break;
                            }
                            case 5: {
                                changedViews = ((Collection)notification.getNewValue()).stream();
                                break;
                            }
                            case 4: {
                                changedViews = Stream.of(notification.getOldValue());
                                break;
                            }
                            case 6: {
                                changedViews = ((Collection)notification.getOldValue()).stream();
                                break;
                            }
                            case 1: {
                                changedViews = Stream.of(notification.getNewValue(), notification.getOldValue());
                                break;
                            }
                            default: {
                                changedViews = Stream.empty();
                            }
                        }
                        changedViews.map(View.class::cast).map(this.elementAdapter.getEngine()::getElement).filter(GMFElementAdapter.class::isInstance).map(GMFElementAdapter.class::cast).forEach(GMFElementAdapter::parentChanged);
                    }
                }
            }
            return;
        }
        if (notification.getNotifier() == this.elementAdapter.getSemanticElement()) {
            this.elementAdapter.semanticPropertyChanged();
            return;
        }
    }

    protected boolean shouldPropagateNotationEvent(Notification notification) {
        boolean result;
        boolean bl = result = notification.getFeature() != NotationPackage.Literals.VIEW__MUTABLE;
        if (result && notification.getFeature() == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS) {
            switch (notification.getEventType()) {
                case 3: {
                    result = !"PapyrusCSSForceValue".equals(((EAnnotation)notification.getNewValue()).getSource());
                    break;
                }
                case 4: {
                    result = !"PapyrusCSSForceValue".equals(((EAnnotation)notification.getOldValue()).getSource());
                }
            }
        }
        return result;
    }

    private String getEventType(Notification notification) {
        switch (notification.getEventType()) {
            case 1: {
                return "SET";
            }
            case 2: {
                return "UNSET";
            }
            case 3: {
                return "ADD";
            }
            case 5: {
                return "ADD_MANY";
            }
            case 4: {
                return "REMOVE";
            }
            case 6: {
                return "REMOVE_MANY";
            }
            case 7: {
                return "MOVE";
            }
            case 8: {
                return "REMOVING_ADAPTER";
            }
            case 9: {
                return "RESOLVE";
            }
        }
        return Integer.toString(notification.getEventType());
    }
}

