/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.AbstractDecoratorModelUpdater;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.IDecoratorModelUpdaterDelegate;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;

public class PostUncontrolDecoratorModelUpdater
extends AbstractDecoratorModelUpdater {
    private final Map<URI, URI> profilesToRemove;
    private Map<URI, URI> profilesRemoved;

    public PostUncontrolDecoratorModelUpdater(IDecoratorModelUpdaterDelegate delegate, PackageRefactoringContext context, URI decoratorModelURI) {
        super(delegate);
        ImmutableMap.Builder extraneousProfiles = ImmutableMap.builder();
        Map<URI, URI> inherited = context.getInheritedExternalProfileApplicationsFor(decoratorModelURI);
        for (Map.Entry<URI, URI> all : context.getAllExternalProfileApplicationsFor(decoratorModelURI).entrySet()) {
            if (!all.getValue().equals(inherited.get(all.getKey()))) continue;
            extraneousProfiles.put((Object)all.getKey(), (Object)all.getValue());
        }
        this.profilesToRemove = extraneousProfiles.build();
    }

    @Override
    public boolean refactor(Resource resource, IProgressMonitor monitor) throws ExecutionException {
        Package evilTwin;
        boolean result = false;
        monitor.beginTask(NLS.bind((String)Messages.PostUncontrolDecoratorModelUpdater_0, (Object)resource.getURI().lastSegment()), -1);
        if (!this.profilesToRemove.isEmpty() && (evilTwin = this.getDecoratorPackage(resource)) != null) {
            for (Map.Entry<URI, URI> next : this.profilesToRemove.entrySet()) {
                EPackage definition;
                ProfileApplication application = this.getProfileApplication(evilTwin, next.getKey());
                EPackage ePackage = definition = application == null ? null : application.getAppliedDefinition();
                if (definition == null || !next.getValue().equals(EcoreUtil.getURI((EObject)definition))) continue;
                application.destroy();
                result = true;
                if (this.profilesRemoved == null) {
                    this.profilesRemoved = Maps.newHashMap();
                }
                this.profilesRemoved.put(next.getKey(), next.getValue());
            }
            if (evilTwin.getProfileApplications().isEmpty()) {
                evilTwin.destroy();
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean unrefactor(Resource resource, IProgressMonitor monitor) throws ExecutionException {
        boolean result = false;
        monitor.beginTask(NLS.bind((String)Messages.PostUncontrolDecoratorModelUpdater_1, (Object)resource.getURI().lastSegment()), -1);
        if (this.profilesRemoved != null) {
            Package evilTwin = this.getDecoratorPackage(resource);
            if (evilTwin == null) {
                evilTwin = this.createDecoratorPackage(resource);
                result = true;
            }
            for (Map.Entry<URI, URI> next : this.profilesRemoved.entrySet()) {
                if (this.hasProfileApplication(evilTwin, next.getKey())) continue;
                this.addProfileApplication(evilTwin, next.getKey(), next.getValue());
                result = true;
            }
            this.profilesRemoved = null;
        }
        return result;
    }
}

