/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.ui.IMemento;

class SharedModelExplorerState
extends EventManager {
    private static final String LINKING_MEMENTO = "linkWithEditor";
    private static final String ENABLED_ATTR = "enabled";
    private static final String SORTING_MEMENTO = "sorting";
    private static final String ALPHA_SORTED_ATTR = "alphaSorted";
    private boolean linkingEnabled;
    private boolean alphaSorted;
    private Set<String> navigatorContentExtensions = Sets.newHashSet();

    SharedModelExplorerState() {
    }

    public void setLinkingEnabled(boolean linkingEnabled) {
        boolean oldValue = this.linkingEnabled;
        this.linkingEnabled = linkingEnabled;
        if (oldValue != linkingEnabled) {
            this.fireStateChanged(1);
        }
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setAlphaSorted(boolean alphaSorted) {
        boolean oldValue = this.alphaSorted;
        this.alphaSorted = alphaSorted;
        if (oldValue != alphaSorted) {
            this.fireStateChanged(2);
        }
    }

    public boolean isAlphaSorted() {
        return this.alphaSorted;
    }

    public void updateNavigatorContentExtensions(String[] contentExtensionIDs, boolean activate) {
        ImmutableSet oldValue = ImmutableSet.copyOf(this.navigatorContentExtensions);
        if (activate) {
            this.navigatorContentExtensions.addAll(Arrays.asList(contentExtensionIDs));
        } else {
            this.navigatorContentExtensions.removeAll(Arrays.asList(contentExtensionIDs));
        }
        if (!oldValue.equals(this.navigatorContentExtensions)) {
            this.fireStateChanged(3);
        }
    }

    public String[] getNavigatorContentExtensions() {
        return (String[])Iterables.toArray(this.navigatorContentExtensions, String.class);
    }

    void load(IMemento memento) {
        this.readLinking(memento);
        this.readSorting(memento);
    }

    public void save(IMemento memento) {
        this.writeLinking(memento);
        this.writeSorting(memento);
    }

    private void readLinking(IMemento memento) {
        IMemento linking = memento.getChild(LINKING_MEMENTO);
        if (linking != null) {
            Boolean enabled = linking.getBoolean(ENABLED_ATTR);
            this.linkingEnabled = enabled != null && enabled != false;
        }
    }

    private void writeLinking(IMemento memento) {
        IMemento linking = memento.getChild(LINKING_MEMENTO);
        if (linking == null) {
            linking = memento.createChild(LINKING_MEMENTO);
        }
        linking.putBoolean(ENABLED_ATTR, this.isLinkingEnabled());
    }

    private void readSorting(IMemento memento) {
        IMemento sorting = memento.getChild(SORTING_MEMENTO);
        if (sorting != null) {
            Boolean sorted = sorting.getBoolean(ALPHA_SORTED_ATTR);
            this.alphaSorted = sorted != null && sorted != false;
        }
    }

    private void writeSorting(IMemento memento) {
        IMemento sorting = memento.getChild(SORTING_MEMENTO);
        if (sorting == null) {
            sorting = memento.createChild(SORTING_MEMENTO);
        }
        sorting.putBoolean(ALPHA_SORTED_ATTR, this.isAlphaSorted());
    }

    public void addListener(StateChangedListener listener) {
        this.addListenerObject(listener);
    }

    public void removeListener(StateChangedListener listener) {
        this.removeListenerObject(listener);
    }

    void fireStateChanged(int eventType) {
        if (this.isListenerAttached()) {
            StateChangedEvent event = new StateChangedEvent(this, eventType);
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((StateChangedListener)listeners[i]).sharedStateChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in shared state listener.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    static class StateChangedEvent
    extends EventObject {
        public static final int LINKING_ENABLED = 1;
        public static final int ALPHA_SORTED = 2;
        public static final int CONTENT_EXTENSIONS = 3;
        private static final long serialVersionUID = 1L;
        private final int type;

        StateChangedEvent(SharedModelExplorerState source, int type) {
            super((Object)source);
            this.type = type;
        }

        public SharedModelExplorerState getSource() {
            return (SharedModelExplorerState)((Object)super.getSource());
        }

        public int getEventType() {
            return this.type;
        }
    }

    static interface StateChangedListener
    extends EventListener {
        public void sharedStateChanged(StateChangedEvent var1);
    }
}

