/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.papyrusgmfgenextension.popupaction;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.PredefinedParser;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.jface.action.IAction;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.Action;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.SetVisualIDWithUnusedValue;
import org.eclipse.ui.IViewPart;

public class AddExternalNodeFloatingLabelDisplayBehavior
extends Action {
    public static final String FIGURE_VIEWMAP_PATH = "org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel";
    public static final String LABEL_POLICY_CLASS = "org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.ExternalLabelPrimaryDragRoleEditPolicy";
    public static final String LABEL_POLICY_KEY = "org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE";
    public static final String DEFAULT_GETTER_NAME = "getFloatingNameLabel";
    public static final String DEFAULT_EDITPART_NAME_SUFFIX = "FloatingLabelEditPart";
    public static final String DEFAULT_EDITPOLICY_NAME_SUFFIX = "FloatingLabelItemSemanticEditPolicy";
    public static final String DEFAULT_PARSER_PATTERN = "";
    public static final String GEN_CLASS_RT_CLASS = "Node";
    public static final String GEN_CLASS_FACET_META_FEATURE = "NamedElement";
    public static final String GEN_FEATURE_FACET_META_FEATURE = "name";
    public static final String URI_NOTATION_GENMODEL = "org.eclipse.gmf.runtime.notation/model/notation.genmodel";
    public static final String URI_UML_GENMODEL = "org.eclipse.uml2.uml/model/UML.genmodel";

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        for (EObject eObject : this.getSelectedEObject()) {
            if (!(eObject instanceof GenNode) || this.hasAnFloatingNameExternalNode((GenNode)eObject)) continue;
            this.createAnFloatingNameExternalNode((GenNode)eObject);
        }
    }

    private void createAnFloatingNameExternalNode(GenNode genNode) {
        GenExternalNodeLabel label = GMFGenFactory.eINSTANCE.createGenExternalNodeLabel();
        String editPartClassName = genNode.getEditPartClassName();
        int index = editPartClassName.indexOf("EditPart");
        String name = String.valueOf(editPartClassName.substring(0, index)) + DEFAULT_EDITPART_NAME_SUFFIX + editPartClassName.substring(index + "EditPart".length());
        label.setEditPartClassName(name);
        label.setItemSemanticEditPolicyClassName(String.valueOf(genNode.getClassNamePrefix()) + DEFAULT_EDITPOLICY_NAME_SUFFIX);
        label.setReadOnly(false);
        int visualID = SetVisualIDWithUnusedValue.getNewVisualID(genNode.eResource(), GenLinkLabel.class);
        label.setVisualID(visualID);
        URI uri_notation = URI.createPlatformPluginURI((String)URI_NOTATION_GENMODEL, (boolean)false);
        Resource notation = genNode.eResource().getResourceSet().getResource(uri_notation, true);
        label.setDiagramRunTimeClass(this.findGenClass(notation, GEN_CLASS_RT_CLASS));
        FigureViewmap viewmap = GMFGenFactory.eINSTANCE.createFigureViewmap();
        viewmap.setFigureQualifiedClassName(FIGURE_VIEWMAP_PATH);
        FeatureLabelModelFacet facet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
        facet.setEditPattern(DEFAULT_PARSER_PATTERN);
        facet.setEditorPattern(DEFAULT_PARSER_PATTERN);
        facet.setViewPattern(DEFAULT_PARSER_PATTERN);
        URI uri_uml = URI.createPlatformPluginURI((String)URI_UML_GENMODEL, (boolean)false);
        Resource uml = genNode.eResource().getResourceSet().getResource(uri_uml, true);
        facet.getMetaFeatures().add((Object)this.findGenFeature(uml, GEN_CLASS_FACET_META_FEATURE, GEN_FEATURE_FACET_META_FEATURE));
        PredefinedParser parser = this.getPredefinedParser(genNode);
        facet.setParser((GenParserImplementation)parser);
        label.setViewmap((Viewmap)viewmap);
        label.setModelFacet((LabelModelFacet)facet);
        this.addCustomBehavior((GenCommonBase)genNode, "org.eclipse.gef.EditPolicy.LAYOUT_ROLE", "org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.GetChildLayoutEditPolicy");
        genNode.getLabels().add((Object)label);
    }

    private PredefinedParser getPredefinedParser(GenNode eObject) {
        PredefinedParser parser = null;
        EList ressourceContents = eObject.eResource().getContents();
        for (EObject ressourceContent : ressourceContents) {
            if (!(ressourceContent instanceof GenEditorGenerator)) continue;
            GenParsers genParsers = ((GenEditorGenerator)ressourceContent).getLabelParsers();
            for (EObject GenParsersContent : genParsers.eContents()) {
                if (!(GenParsersContent instanceof PredefinedParser)) continue;
                parser = (PredefinedParser)GenParsersContent;
            }
        }
        return parser;
    }

    public boolean hasAnFloatingNameExternalNode(GenNode node) {
        for (GenNodeLabel currentGenNodeLabel : node.getLabels()) {
            if (!(currentGenNodeLabel instanceof GenExternalNodeLabel) || !this.isAnFloatingNameExternalNode((GenExternalNodeLabel)currentGenNodeLabel)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnFloatingNameExternalNode(GenExternalNodeLabel node) {
        return node.getEditPartClassName().contains(DEFAULT_EDITPART_NAME_SUFFIX);
    }
}

