/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.svgextension;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramImageGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramSVGGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageExporter;
import org.eclipse.papyrus.uml.export.extension.AnnotateSVG;
import org.eclipse.papyrus.uml.export.svgextension.PapyrusDiagramSVGGenerator;
import org.eclipse.swt.graphics.Rectangle;

public class PapyrusCopyToImageUtil
extends CopyToImageUtil {
    private List<AnnotateSVG> annotations = new ArrayList<AnnotateSVG>();

    public PapyrusCopyToImageUtil(List<AnnotateSVG> annotations) {
        this.annotations = annotations;
    }

    protected DiagramGenerator getDiagramGenerator(DiagramEditPart diagramEP, ImageFileFormat format) {
        if (format.equals((Object)ImageFileFormat.SVG) || format.equals((Object)ImageFileFormat.PDF)) {
            return new PapyrusDiagramSVGGenerator(diagramEP, this.annotations);
        }
        return new DiagramImageGenerator(diagramEP);
    }

    protected void copyToImage(DiagramGenerator gen, List editParts, Rectangle imageRect, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        boolean found = false;
        if (format.equals((Object)ImageFileFormat.SVG) || format.equals((Object)ImageFileFormat.PDF)) {
            ((PapyrusDiagramSVGGenerator)gen).openCreateSWTImageDescriptorForParts(editParts, imageRect);
            monitor.worked(1);
            this.saveToFile(destination, (DiagramSVGGenerator)gen, format, monitor);
            found = true;
        } else if (format.equals((Object)ImageFileFormat.JPEG) || format.equals((Object)ImageFileFormat.PNG)) {
            String exportFormat = "JPEG";
            if (format.equals((Object)ImageFileFormat.PNG)) {
                exportFormat = "PNG";
            }
            Image image = gen.createAWTImageForParts(editParts, imageRect);
            monitor.worked(1);
            if (image instanceof BufferedImage) {
                ImageExporter.exportToFile((IPath)destination, (BufferedImage)((BufferedImage)image), (String)exportFormat, (IProgressMonitor)monitor, (float)format.getQuality());
                found = true;
            }
        }
        if (!found) {
            org.eclipse.swt.graphics.Image image = gen.createSWTImageDescriptorForParts(editParts, imageRect).createImage();
            monitor.worked(1);
            this.saveToFile(destination, image, format, monitor);
            image.dispose();
        }
    }
}

