/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.editparts.IFloatingLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AllowResizeAffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.swt.graphics.Cursor;

public class ExecutionSpecificationAffixedChildAlignmentPolicy
extends AllowResizeAffixedNodeAlignmentEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof IBorderItemEditPart && !(child instanceof IFloatingLabelEditPart)) {
            BorderItemResizableEditPolicy policy = new BorderItemResizableEditPolicy(){

                protected void createResizeHandle(List handles, int direction) {
                    if ((this.getResizeDirections() & direction) == direction) {
                        ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), (List)handles, (int)direction, (DragTracker)this.getResizeTracker(direction), (Cursor)Cursors.getDirectionalCursor((int)direction, (boolean)this.getHostFigure().isMirrored()));
                    }
                }

                protected ResizeTracker getResizeTracker(int direction) {
                    return new TimeElementResizeTracker((GraphicalEditPart)this.getHost(), direction);
                }

                protected Command getAutoSizeCommand(Request request) {
                    return null;
                }

                protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                    IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
                    IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
                    if (borderItemLocator != null) {
                        IFigure feedback = this.getDragSourceFeedbackFigure();
                        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                        EditPart part = borderItemEP.getParent();
                        Point p = ((IGraphicalEditPart)part).getFigure().getBounds().getLocation().getNegated();
                        rect.translate(p);
                        double scale = FigureUtils.getScale((IFigure)this.getHostFigure());
                        Point moveDelta = request.getMoveDelta().getCopy();
                        moveDelta.scale(1.0 / scale);
                        rect.translate(moveDelta);
                        Dimension sizeDelta = request.getSizeDelta().getCopy();
                        sizeDelta.scale(1.0 / scale);
                        rect.resize(sizeDelta);
                        IFigure borderItemfigure = borderItemEP.getFigure();
                        Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemfigure);
                        this.getHostFigure().translateToAbsolute((Translatable)realLocation);
                        feedback.translateToRelative((Translatable)realLocation);
                        feedback.setBounds(realLocation);
                    }
                }
            };
            policy.setResizeDirections(24);
            policy.setDragAllowed(false);
            return policy;
        }
        EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
        if (result == null) {
            result = new NonResizableEditPolicy();
        }
        return result;
    }

    public class TimeElementResizeTracker
    extends ResizeTracker {
        public TimeElementResizeTracker(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected List<EditPart> createOperationSet() {
            return Collections.singletonList(this.getOwner());
        }

        protected Request createSourceRequest() {
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
            request.setConstrainedResize(false);
            request.setResizeDirection(this.getResizeDirection());
            return request;
        }

        protected Command getCommand() {
            return super.getCommand();
        }

        protected void updateSourceRequest() {
            super.updateSourceRequest();
        }

        protected Dimension getMinimumSizeFor(ChangeBoundsRequest request) {
            return new Dimension(20, 1);
        }

        protected void showSourceFeedback() {
            super.showSourceFeedback();
        }
    }
}

