/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.papyrus.uml.properties.widgets.StereotypeExplorerDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class ProfileExplorerDialog
extends StereotypeExplorerDialog {
    public ProfileExplorerDialog(Shell parentShell, boolean allowMultiple, String initialQualifyName) {
        super(parentShell, allowMultiple, initialQualifyName);
        this.setTitle(Messages.ProfileExplorerDialog_Title);
        this.setMessage(Messages.ProfileExplorerDialog_Message);
    }

    public ProfileExplorerDialog(Shell parentShell, String initialValue) {
        this(parentShell, false, initialValue);
    }

    public ProfileExplorerDialog(Shell parentShell) {
        this(parentShell, false, "");
    }

    @Override
    protected boolean isVisible(Object element) {
        return true;
    }

    @Override
    protected List<Stereotype> getAllStereotypes(Profile profile) {
        return new ArrayList<Stereotype>();
    }

    @Override
    protected void computeResult() {
        Object selectedElements = this.getSelectedElements();
        if (selectedElements instanceof Profile | selectedElements instanceof IRegisteredProfile) {
            this.setResult(Arrays.asList(selectedElements));
        }
    }

    @Override
    protected void refreshOkButton() {
        Object selectedElements = this.getSelectedElements();
        if (selectedElements instanceof Profile | selectedElements instanceof IRegisteredProfile) {
            this.updateStatus((IStatus)new Status(0, "org.eclipse.papyrus.uml.diagram.common", ""));
        } else {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.papyrus.uml.diagram.common", ""));
        }
    }

    @Override
    protected void selectInitialValue() {
        if (!this.initialValue.isEmpty()) {
            Object[] roots;
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.stereotypeTreeViewer.getContentProvider();
            Object[] objectArray = roots = contentProvider.getElements(null);
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] profiles;
                Object root = objectArray[n2];
                Object[] objectArray2 = profiles = contentProvider.getChildren(root);
                if (profiles.length != 0) {
                    Object profile = objectArray2[0];
                    this.stereotypeTreeViewer.setSelection((ISelection)new StructuredSelection(profile), true);
                }
                ++n2;
            }
        }
    }
}

