/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;

public class ElementTypesDependenciesChecker
implements IPluginChecker {
    private final Collection<String> NEEDED_REQUIRED_PLUGINS = new HashSet<String>(){
        {
            this.add("org.eclipse.papyrus.infra.types.core");
            this.add("org.eclipse.gmf.runtime.emf.type.core");
            this.add("org.eclipse.papyrus.uml.service.types");
            this.add("org.eclipse.papyrus.infra.services.edit");
            this.add("org.eclipse.papyrus.infra.types");
            this.add("org.eclipse.papyrus.uml.tools.utils");
        }
    };
    private final IProject project;

    public ElementTypesDependenciesChecker(IProject project) {
        this.project = project;
    }

    public void check(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Validate dependencies for element types.");
        }
        HashSet<String> requiredPlugins = new HashSet<String>();
        this.NEEDED_REQUIRED_PLUGINS.stream().forEach(needRequiredPlugin -> {
            boolean bl = requiredPlugins.add((String)needRequiredPlugin);
        });
        HashSet existingRequiredPlugins = new HashSet();
        List dependencies = ProjectManagementService.getPluginDependencies((IProject)this.project);
        if (dependencies != null && !dependencies.isEmpty()) {
            dependencies.stream().forEach(dependency -> {
                boolean bl = existingRequiredPlugins.add(dependency.getName());
            });
            requiredPlugins.removeIf(requiredPlugin -> existingRequiredPlugins.contains(requiredPlugin));
        }
        if (!requiredPlugins.isEmpty()) {
            IFile manifestFile = ProjectManagementService.getManifestFile((IContainer)this.project);
            requiredPlugins.stream().forEach(requiredPlugin -> MarkersService.createMarker((IResource)manifestFile, (String)"org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", (String)("The plug-in '" + requiredPlugin + "' must be defined as required plug-in."), (int)1));
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

