/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import java.util.Objects;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;

public class TouchableValue<T>
extends ReferenceCountedObservable.Value<T> {
    private final Class<? extends T> type;
    private T value;

    public TouchableValue(Realm realm, Class<? extends T> type) {
        super(realm);
        this.type = type;
    }

    public TouchableValue(Realm realm, Class<? extends T> type, T initialValue) {
        super(realm);
        this.type = type;
        this.value = initialValue;
    }

    public Object getValueType() {
        return this.type;
    }

    protected T doGetValue() {
        return this.value;
    }

    protected void doSetValue(T value) {
        if (!Objects.equals(this.value, value)) {
            T oldValue = this.value;
            this.value = value;
            this.fireValueChange(Diffs.createValueDiff(oldValue, value));
        }
    }

    public void touch() {
        this.checkRealm();
        this.fireEvent((ObservableEvent)new ChangeEvent((IObservable)this));
    }
}

