/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.navigation.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.navigation.Activator;
import org.eclipse.papyrus.infra.services.navigation.provider.NavigationTargetProvider;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationContributor;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenu;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuContributor;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;

public class NavigationServiceImpl
implements NavigationService {
    public static final String NAVIGATION_CONTRIBUTOR_EXTENSION_ID = "org.eclipse.papyrus.infra.services.navigation.navigationContributor";
    public static final String NAVIGATION_MENU_CONTRIBUTOR_EXTENSION_ID = "org.eclipse.papyrus.infra.services.navigation.navigationMenuContributor";
    public static final String NAVIGATION_MENU_EXTENSION_ID = "org.eclipse.papyrus.infra.services.navigation.navigationMenu";
    public static final String IS_ACTIVE_KEY = "isActive";
    protected ServicesRegistry registry;
    private List<NavigationContributorDescriptor> navigationContributors;
    private Collection<NavigationTargetProvider> navigationTargetProviders;
    private List<NavigationMenuContributorDescriptor> navigationMenuContributors;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        this.createNavigationContributors();
        this.createNavigationTargetProviders();
        this.createNavigationMenuContributors();
    }

    protected void createNavigationContributors() {
        IConfigurationElement[] config;
        this.navigationContributors = new LinkedList<NavigationContributorDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(NAVIGATION_CONTRIBUTOR_EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if ("contributor".equals(e.getName())) {
                try {
                    Object instance = e.createExecutableExtension("contributor");
                    if (instance instanceof NavigationContributor) {
                        NavigationContributorDescriptor wrapper = new NavigationContributorDescriptor((NavigationContributor)instance);
                        wrapper.setId(e.getAttribute("id"));
                        wrapper.setLabel(e.getAttribute("label"));
                        wrapper.setDescription(e.getAttribute("description"));
                        wrapper.init();
                        this.navigationContributors.add(wrapper);
                    }
                }
                catch (Exception ex) {
                    Activator.log.warn("Invalid navigation contribution from: " + e.getContributor());
                }
            }
            ++n2;
        }
    }

    protected void createNavigationMenuContributors() {
        IConfigurationElement[] config;
        this.navigationMenuContributors = new LinkedList<NavigationMenuContributorDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(NAVIGATION_MENU_CONTRIBUTOR_EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if ("contributor".equals(e.getName())) {
                try {
                    Object instance = e.createExecutableExtension("contributor");
                    if (instance instanceof NavigationMenuContributor) {
                        NavigationMenuContributorDescriptor wrapper = new NavigationMenuContributorDescriptor((NavigationMenuContributor)instance);
                        wrapper.setId(e.getAttribute("id"));
                        wrapper.setLabel(e.getAttribute("label"));
                        wrapper.setDescription(e.getAttribute("description"));
                        wrapper.init();
                        this.navigationMenuContributors.add(wrapper);
                    }
                }
                catch (Exception ex) {
                    Activator.log.warn("Invalid navigation contribution from: " + e.getContributor());
                }
            }
            ++n2;
        }
    }

    protected void createNavigationTargetProviders() {
        IConfigurationElement[] config;
        this.navigationTargetProviders = new TreeSet<NavigationTargetProvider>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(NAVIGATION_CONTRIBUTOR_EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if ("target".equals(e.getName())) {
                try {
                    Object instance = e.createExecutableExtension("navigationTargetProvider");
                    if (instance instanceof NavigationTargetProvider) {
                        NavigationTargetProviderDescriptor descriptor = new NavigationTargetProviderDescriptor((NavigationTargetProvider)instance);
                        descriptor.setId(e.getAttribute("id"));
                        descriptor.setLabel(e.getAttribute("label"));
                        descriptor.setDescription(e.getAttribute("description"));
                        descriptor.setOrder(Integer.parseInt(e.getAttribute("order")));
                        this.navigationTargetProviders.add(descriptor);
                    }
                }
                catch (Exception ex) {
                    Activator.log.warn("Invalid navigation target contribution from: " + e.getContributor());
                }
            }
            ++n2;
        }
    }

    public void disposeService() throws ServiceException {
        this.registry = null;
    }

    @Override
    public List<NavigableElement> getNavigableElements(Object fromElement) {
        LinkedList<NavigableElement> navigableElements = new LinkedList<NavigableElement>();
        for (NavigationContributorDescriptor contributor : this.navigationContributors) {
            if (!contributor.isActive()) continue;
            navigableElements.addAll(contributor.getNavigableElements(fromElement));
        }
        return navigableElements;
    }

    @Override
    public List<NavigationMenuButton> getButtons(Object fromElement) {
        LinkedList<NavigationMenuButton> buttons = new LinkedList<NavigationMenuButton>();
        for (NavigationMenuContributorDescriptor contributor : this.navigationMenuContributors) {
            if (!contributor.isActive()) continue;
            buttons.addAll(contributor.getButtons(fromElement));
        }
        return buttons;
    }

    public List<NavigationContributorDescriptor> getNavigationContributors() {
        return this.navigationContributors;
    }

    public Collection<NavigationTargetProvider> getNavigationTargetProviders() {
        return this.navigationTargetProviders;
    }

    public List<NavigationMenuContributorDescriptor> getNavigationMenuContributors() {
        return this.navigationMenuContributors;
    }

    @Override
    public NavigationMenu createNavigationList() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(NAVIGATION_MENU_EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if ("menu".equals(e.getName())) {
                try {
                    Object instance = e.createExecutableExtension("menu");
                    if (instance instanceof NavigationMenu) {
                        return (NavigationMenu)instance;
                    }
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    Activator.log.warn("Invalid navigation menu from: " + e.getContributor());
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void navigate(NavigableElement navigableElement) {
        if (this.registry == null) {
            throw new IllegalStateException("The navigation service is not initialized");
        }
        for (NavigationTargetProvider provider : this.getNavigationTargetProviders()) {
            NavigationTarget target = provider.getNavigationTarget(this.registry);
            if (target == null || !navigableElement.navigate(target)) continue;
            return;
        }
    }

    @Override
    public void navigate(Object element) {
        if (this.registry == null) {
            throw new IllegalStateException("The navigation service is not initialized");
        }
        for (NavigationTargetProvider provider : this.getNavigationTargetProviders()) {
            NavigationTarget target = provider.getNavigationTarget(this.registry);
            if (target == null || !target.revealElement(element)) continue;
            return;
        }
    }

    @Override
    public void navigate(Object element, String providerId) {
        if (this.registry == null) {
            throw new IllegalStateException("The navigation service is not initialized");
        }
        for (NavigationTargetProvider provider : this.getNavigationTargetProviders()) {
            NavigationTarget target;
            if (!((NavigationTargetProviderDescriptor)provider).getId().equals(providerId) || (target = provider.getNavigationTarget(this.registry)) == null || !target.revealElement(element)) continue;
            return;
        }
    }

    public static class ContributorDescriptor {
        private String label;
        private String description;
        private String id;
        private final IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();

        public void init() {
            String isActiveKey = ContributorDescriptor.getIsActiveKey(this);
            this.preferences.setDefault(isActiveKey, true);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isActive() {
            String preferenceKey = ContributorDescriptor.getIsActiveKey(this);
            return this.preferences.getBoolean(preferenceKey);
        }

        public static String getIsActiveKey(ContributorDescriptor strategy) {
            return String.valueOf(strategy.getId()) + "." + NavigationServiceImpl.IS_ACTIVE_KEY;
        }
    }

    public static class NavigationContributorDescriptor
    extends ContributorDescriptor
    implements NavigationContributor {
        private final NavigationContributor contributor;

        public NavigationContributorDescriptor(NavigationContributor contributor) {
            this.contributor = contributor;
        }

        @Override
        public List<NavigableElement> getNavigableElements(Object fromElement) {
            if (this.isActive()) {
                return this.contributor.getNavigableElements(fromElement);
            }
            return Collections.emptyList();
        }
    }

    public static class NavigationMenuContributorDescriptor
    extends ContributorDescriptor
    implements NavigationMenuContributor {
        private final NavigationMenuContributor contributor;

        public NavigationMenuContributorDescriptor(NavigationMenuContributor contributor) {
            this.contributor = contributor;
        }

        @Override
        public List<NavigationMenuButton> getButtons(Object fromElement) {
            if (this.isActive()) {
                return this.contributor.getButtons(fromElement);
            }
            return Collections.emptyList();
        }
    }

    public static class NavigationTargetProviderDescriptor
    implements NavigationTargetProvider,
    Comparable<NavigationTargetProviderDescriptor> {
        private NavigationTargetProvider provider;
        private int order;
        private String label;
        private String description;
        private String id;

        public NavigationTargetProviderDescriptor(NavigationTargetProvider provider) {
            this.provider = provider;
        }

        @Override
        public NavigationTarget getNavigationTarget(ServicesRegistry registry) {
            return this.provider.getNavigationTarget(registry);
        }

        public int getOrder() {
            return this.order;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public int compareTo(NavigationTargetProviderDescriptor o) {
            if (o == null) {
                return -1;
            }
            if (o.order == this.order) {
                return 0;
            }
            return o.order < this.order ? 1 : -1;
        }
    }
}

