/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.commands.CopyImageCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.INonDirtying;
import org.eclipse.papyrus.commands.util.NonDirtyingUtils;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.DefaultDiagramCopyCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.PasteStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyInDiagramHandler
extends AbstractGraphicalCommandHandler {
    private static final String COPY_COMMAND_LABEL = "Copy In Diagram";
    private static final String COPY_IMAGE_COMMAND_LABEL = "Create image to allow paste on system";
    private Object activeFocusControl = null;
    private Object activeShell = null;

    public static org.eclipse.gef.commands.Command buildCopyCommand(TransactionalEditingDomain editingDomain, Collection<IGraphicalEditPart> selectedElements) {
        PapyrusClipboard papyrusClipboard = PapyrusClipboard.getNewInstance();
        DefaultDiagramCopyCommand defaultDiagramCopyCommand = new DefaultDiagramCopyCommand((EditingDomain)editingDomain, papyrusClipboard, selectedElements);
        org.eclipse.gef.commands.Command result = EMFtoGEFCommandWrapper.wrap((Command)defaultDiagramCopyCommand);
        IDiagramWorkbenchPart activeDiagramWorkbenchPart = DiagramEditPartsUtil.getActiveDiagramWorkbenchPart();
        Diagram diagram = activeDiagramWorkbenchPart.getDiagram();
        DiagramEditPart diagramEditPart = activeDiagramWorkbenchPart.getDiagramEditPart();
        ArrayList<Object> selectedElementModels = new ArrayList<Object>();
        for (IGraphicalEditPart iGraphicalEditPart : selectedElements) {
            selectedElementModels.add(iGraphicalEditPart.getModel());
        }
        PapyrusCopyImageCommand copyImageCommand = new PapyrusCopyImageCommand(COPY_IMAGE_COMMAND_LABEL, (View)diagram, selectedElementModels, diagramEditPart);
        if (copyImageCommand.canExecute()) {
            org.eclipse.gef.commands.Command gmFtoGEFCommandWrapper = GMFtoGEFCommandWrapper.wrap((ICommand)copyImageCommand);
            result = NonDirtyingUtils.chain((org.eclipse.gef.commands.Command)result, (org.eclipse.gef.commands.Command)gmFtoGEFCommandWrapper);
        } else {
            copyImageCommand.dispose();
        }
        List allStrategies = PasteStrategyManager.getInstance().getAllStrategies();
        for (IStrategy iStrategy : allStrategies) {
            IPasteStrategy iIPasteStrategy = (IPasteStrategy)iStrategy;
            iIPasteStrategy.prepare(papyrusClipboard, null);
        }
        result.setLabel(COPY_COMMAND_LABEL);
        return result;
    }

    @Override
    protected org.eclipse.gef.commands.Command getCommand() {
        return CopyInDiagramHandler.buildCopyCommand(this.getEditingDomain(), this.getSelectedElements());
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            this.activeFocusControl = iEvaluationContext.getVariable("activeFocusControl");
            this.activeShell = iEvaluationContext.getVariable("activeShell");
        }
        super.setEnabled(evaluationContext);
    }

    @Override
    protected boolean computeEnabled() {
        Shell shell;
        Display display;
        boolean isEnable = false;
        Control focusControl = null;
        if (this.activeShell instanceof Shell && (display = (shell = (Shell)this.activeShell).getDisplay()) != null) {
            focusControl = display.getFocusControl();
        }
        if (!(this.activeFocusControl instanceof StyledText) && !(focusControl instanceof Text)) {
            PapyrusClipboard instance = PapyrusClipboard.getInstance();
            PapyrusClipboard.setInstance((PapyrusClipboard)instance);
            isEnable = true;
        }
        return isEnable;
    }

    static class PapyrusCopyImageCommand
    extends CopyImageCommand
    implements INonDirtying {
        PapyrusCopyImageCommand(String label, View viewContext, List source, DiagramEditPart diagramEP) {
            super(label, viewContext, source, diagramEP);
        }

        public boolean canExecute() {
            return AWTClipboardHelper.getInstance().isImageCopySupported();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return CommandResult.newOKCommandResult();
        }
    }
}

