/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.papyrus.infra.tools.Activator;

public class Suppliers2 {
    private Suppliers2() {
    }

    public static <V> Supplier<V> eventualSupplier(Future<V> future) {
        return Suppliers2.eventualSupplier(future, null);
    }

    public static <V> Supplier<V> eventualSupplier(Future<V> future, V defaultValue) {
        return future instanceof ListenableFuture ? new ListenableFutureSupplier<V>((ListenableFuture)future, defaultValue) : new FutureSupplier<V>(future, defaultValue);
    }

    private static class FutureSupplier<V>
    implements Supplier<V> {
        private Future<V> future;
        private V value;

        FutureSupplier(Future<V> future, V defaultValue) {
            this.future = future;
            this.value = defaultValue;
        }

        public V get() {
            block10: {
                if (this.value == null && this.future != null && this.future.isDone()) {
                    try {
                        if (this.future.isCancelled()) {
                            Activator.log.warn("Future of EventualSupplier was cancelled: " + this.future);
                        } else {
                            this.value = this.future.get();
                        }
                    }
                    catch (InterruptedException e) {
                        Activator.log.error("Interrupted on a done future.", (Throwable)e);
                        this.future = null;
                        break block10;
                    }
                    catch (ExecutionException e) {
                        try {
                            Activator.log.error("Future execution failed", e.getCause());
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.future = null;
                        }
                    }
                    this.future = null;
                }
            }
            return this.value;
        }
    }

    private static class ListenableFutureSupplier<V>
    implements Supplier<V> {
        private AtomicReference<V> value;

        ListenableFutureSupplier(ListenableFuture<V> future, V defaultValue) {
            this.value = new AtomicReference<V>(defaultValue);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<V>(){

                public void onSuccess(V result) {
                    value.set(result);
                }

                public void onFailure(Throwable t) {
                    Activator.log.error("Future execution failed", t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public V get() {
            return this.value.get();
        }
    }
}

