/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import org.eclipse.emf.common.util.TreeIterator;

public class TreeIterators {
    private TreeIterators() {
    }

    public static <T> TreeIterator<T> filter(TreeIterator<?> iterator, final Class<T> type) {
        return new DelegatingTreeIterator<Object, T>(iterator){

            @Override
            protected T computeNext(Object input) {
                return type.isInstance(input) ? (Object)type.cast(input) : null;
            }
        };
    }

    public static <T> TreeIterator<T> filter(TreeIterator<T> iterator, final Predicate<? super T> predicate) {
        return new DelegatingTreeIterator<T, T>(iterator){

            @Override
            protected T computeNext(T input) {
                return predicate.apply(input) ? input : null;
            }
        };
    }

    private static abstract class DelegatingTreeIterator<F, T>
    extends AbstractIterator<T>
    implements TreeIterator<T> {
        private final TreeIterator<? extends F> delegate;
        private boolean done;

        DelegatingTreeIterator(TreeIterator<? extends F> delegate) {
            this.delegate = delegate;
        }

        protected T computeNext() {
            while (this.delegate.hasNext()) {
                Object next = this.delegate.next();
                T result = this.computeNext(next);
                if (result != null) {
                    return result;
                }
                if (this.done) break;
            }
            return (T)this.endOfData();
        }

        protected abstract T computeNext(F var1);

        protected final T stop() {
            this.done = true;
            return null;
        }

        public void prune() {
            this.delegate.prune();
        }
    }
}

