/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.geometry;

import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.infra.gmfdiag.common.geometry.Segment;

public class RectangleUtils {
    private RectangleUtils() {
    }

    public static final PrecisionPoint getIntersectionPoint(Rectangle rect, Segment segment) {
        PrecisionPoint result = null;
        Segment topSegment = new Segment(rect.getTopLeft(), rect.getTopRight());
        result = segment.getIntersection(topSegment);
        if (result == null) {
            Segment rightSegment = new Segment(rect.getTopRight(), rect.getBottomRight());
            result = segment.getIntersection(rightSegment);
        }
        if (result == null) {
            Segment bottomSegment = new Segment(rect.getBottomRight(), rect.getBottomLeft());
            result = segment.getIntersection(bottomSegment);
        }
        if (result == null) {
            Segment leftSegment = new Segment(rect.getBottomLeft(), rect.getTopLeft());
            result = segment.getIntersection(leftSegment);
        }
        return result;
    }
}

