/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.batik.dom.svg.AbstractSVGPathSegList;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.SlidableEllipseAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ICustomNodePlate;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ScalableCompartmentFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGNodePlateFigure
extends DefaultSizeNodeFigure {
    protected SVGDocument svgDocument = null;
    private PrecisionDimension svgDimension = null;
    private List<PrecisionPoint> outlinePoints = null;
    private PrecisionDimension outlineDimension = null;
    private PrecisionRectangle labelBounds = null;
    protected DefaultSizeNodeFigure defaultNodePlate;
    protected boolean followSVGPapyrusPath = false;

    public void setFollowSVGPapyrusPath(boolean followSVGPapyrusPath) {
        this.followSVGPapyrusPath = followSVGPapyrusPath;
    }

    public SVGNodePlateFigure(int width, int height) {
        super(width, height);
    }

    public void setSVGDocument(SVGDocument svgDocument) {
        this.svgDocument = svgDocument;
        if (svgDocument != null) {
            this.svgDimension = this.getSvgDimension(svgDocument);
            Element element = svgDocument.getElementById("PapyrusPath");
            if (element != null) {
                this.outlinePoints = this.toDraw2DPoints(((SVGPathElement)element).getPathSegList());
                this.outlineDimension = this.getDimensionOf(this.outlinePoints);
            } else {
                this.outlinePoints = null;
                this.outlineDimension = null;
            }
            element = svgDocument.getElementById("PapyrusLabel");
            if (element != null) {
                this.labelBounds = this.toDraw2DRectangle((SVGRectElement)element);
            }
        } else {
            this.svgDimension = null;
            this.outlinePoints = null;
            this.outlineDimension = null;
            this.labelBounds = null;
        }
    }

    private double getValueOf(SVGAnimatedLength length) {
        if (length == null) {
            return 0.0;
        }
        SVGLength base = length.getBaseVal();
        if (base == null) {
            return 0.0;
        }
        try {
            return base.getValue();
        }
        catch (NullPointerException e) {
            return base.getValueInSpecifiedUnits();
        }
    }

    private PrecisionDimension getSvgDimension(SVGDocument svgDocument) {
        double svgWidth = 0.0;
        double svgHeight = 0.0;
        SVGSVGElement svgElement = svgDocument.getRootElement();
        if (svgElement != null) {
            svgWidth = this.getValueOf(svgElement.getWidth());
            svgHeight = this.getValueOf(svgElement.getHeight());
        }
        return new PrecisionDimension(svgWidth, svgHeight);
    }

    private List<PrecisionPoint> toDraw2DPoints(SVGPathSegList segments) {
        ArrayList<PrecisionPoint> pointList = new ArrayList<PrecisionPoint>();
        double currentX = 0.0;
        double currentY = 0.0;
        PrecisionPoint firstPoint = new PrecisionPoint();
        Boolean firstPointAbsolue = true;
        int i = 0;
        while (i < segments.getNumberOfItems()) {
            SVGPathSeg seg = segments.getItem(i);
            if (seg instanceof AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem) {
                AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem linetoItem = (AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem)seg;
                String letter = linetoItem.getPathSegTypeAsLetter();
                double x = linetoItem.getX();
                double y = linetoItem.getY();
                if (letter.equals("M")) {
                    currentX = x;
                    currentY = y;
                    firstPoint.setPreciseLocation(currentX, currentY);
                    firstPointAbsolue = true;
                    pointList.add(new PrecisionPoint(currentX, currentY));
                } else if (letter.equals("m")) {
                    firstPoint.setPreciseLocation(currentX += x, currentY += y);
                    firstPointAbsolue = false;
                    pointList.add(new PrecisionPoint(currentX, currentY));
                } else if (letter.equals("L")) {
                    currentX = x;
                    currentY = y;
                    pointList.add(new PrecisionPoint(currentX, currentY));
                } else if (letter.equals("l")) {
                    pointList.add(new PrecisionPoint(currentX += x, currentY += y));
                }
            } else if (seg instanceof SVGPathSeg) {
                String letter = seg.getPathSegTypeAsLetter();
                if (letter.equals("z")) {
                    if (firstPointAbsolue.booleanValue()) {
                        pointList.add(firstPoint);
                    } else {
                        pointList.add(new PrecisionPoint(currentX += firstPoint.preciseX(), currentY += firstPoint.preciseY()));
                    }
                }
            } else {
                System.err.println("Unsupported SVG segment in PapyrusPath at index " + i + " in SVG document");
            }
            ++i;
        }
        return pointList;
    }

    private PrecisionDimension getDimensionOf(Collection<PrecisionPoint> points) {
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (PrecisionPoint point : points) {
            maxWidth = Math.max(maxWidth, point.preciseX());
            maxHeight = Math.max(maxHeight, point.preciseY());
        }
        return new PrecisionDimension(maxWidth, maxHeight);
    }

    private PrecisionRectangle toDraw2DRectangle(SVGRectElement element) {
        return new PrecisionRectangle(this.getValueOf(element.getX()), this.getValueOf(element.getY()), this.getValueOf(element.getWidth()), this.getValueOf(element.getHeight()));
    }

    public void setDefaultNodePlate(IFigure defaultNodePlate) {
        if (defaultNodePlate instanceof DefaultSizeNodeFigure) {
            this.defaultNodePlate = (DefaultSizeNodeFigure)defaultNodePlate;
            this.setDefaultSize(((DefaultSizeNodeFigure)defaultNodePlate).getDefaultSize());
        }
        if (defaultNodePlate instanceof ICustomNodePlate) {
            ((ICustomNodePlate)this.defaultNodePlate).setSVGNodePlateContainer(this);
        }
    }

    private SvgToDraw2DTransform getTransform(double innerWidth, double innerHeight, Rectangle anchor) {
        PrecisionDimension maxDim = new PrecisionDimension(Math.max(this.svgDimension.preciseWidth(), innerWidth), Math.max(this.svgDimension.preciseHeight(), innerHeight));
        boolean isRatioMaintained = false;
        ScalableImageFigure scalableImage = FigureUtils.findChildFigureInstance(this.getParent(), ScalableImageFigure.class);
        if (scalableImage != null) {
            isRatioMaintained = scalableImage.isMaintainAspectRatio();
        }
        if (isRatioMaintained) {
            double ratio = this.svgDimension.preciseWidth() / this.svgDimension.preciseHeight();
            double scaleX = 0.0;
            double scaleY = 0.0;
            double tranlationX = anchor.x;
            double tranlationY = anchor.y;
            if (anchor.height < anchor.width) {
                if ((double)anchor.height * ratio < (double)anchor.width) {
                    scaleX = (double)anchor.height / maxDim.preciseHeight();
                    scaleY = (double)anchor.height / maxDim.preciseHeight();
                    tranlationX = (double)anchor.x + (anchor.preciseWidth() / 2.0 - anchor.preciseHeight() * ratio / 2.0);
                } else {
                    scaleX = (double)anchor.width / maxDim.preciseWidth();
                    scaleY = (double)anchor.width / maxDim.preciseWidth();
                    tranlationY = (double)anchor.y + (anchor.preciseHeight() / 2.0 - anchor.preciseWidth() / ratio / 2.0);
                }
            } else if ((double)anchor.height > (double)anchor.width / ratio) {
                scaleX = (double)anchor.width / maxDim.preciseWidth();
                scaleY = (double)anchor.width / maxDim.preciseWidth();
                tranlationY = (double)anchor.y + (anchor.preciseHeight() / 2.0 - anchor.preciseWidth() / ratio / 2.0);
            } else {
                scaleX = (double)anchor.height / maxDim.preciseHeight();
                scaleY = (double)anchor.height / maxDim.preciseHeight();
                tranlationX = (double)anchor.x + (anchor.preciseWidth() / 2.0 - anchor.preciseHeight() * ratio / 2.0);
            }
            return new SvgToDraw2DTransform(scaleX, scaleY, tranlationX, tranlationY);
        }
        return new SvgToDraw2DTransform((double)anchor.width / maxDim.preciseWidth(), (double)anchor.height / maxDim.preciseHeight(), anchor.x, anchor.y);
    }

    private Rectangle getDraw2DAnchor() {
        if (this.getChildren().size() > 0 && this.getChildren().get(0) instanceof IFigure) {
            IFigure primaryShape = (IFigure)this.getChildren().get(0);
            for (Object subFigure : primaryShape.getChildren()) {
                if (!(subFigure instanceof ScalableCompartmentFigure)) continue;
                return ((IFigure)subFigure).getBounds();
            }
        }
        return this.getHandleBounds();
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (this.outlinePoints == null || !this.followSVGPapyrusPath) {
            if (this.defaultNodePlate instanceof IOvalAnchorableFigure) {
                this.defaultNodePlate.setBounds(this.getBounds());
                if (p != null) {
                    return new SlidableEllipseAnchor((IFigure)this, p);
                }
            }
            if (this.defaultNodePlate instanceof IRoundedRectangleFigure) {
                this.defaultNodePlate.setBounds(this.getBounds());
                if (p != null) {
                    return new SlidableRoundedRectangleAnchor((NodeFigure)this, p);
                }
            }
            return super.createAnchor(p);
        }
        return super.createAnchor(p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        if (this.outlinePoints == null || !this.followSVGPapyrusPath) {
            if (this.defaultNodePlate instanceof IOvalAnchorableFigure) {
                this.defaultNodePlate.setBounds(this.getBounds());
                return new SlidableEllipseAnchor((IFigure)this);
            }
            if (this.defaultNodePlate instanceof IRoundedRectangleFigure) {
                this.defaultNodePlate.setBounds(this.getBounds());
                return new SlidableRoundedRectangleAnchor((NodeFigure)this);
            }
        }
        return super.createDefaultAnchor();
    }

    public PointList getPolygonPoints() {
        if (this.outlinePoints == null || !this.followSVGPapyrusPath) {
            if (this.defaultNodePlate != null) {
                this.defaultNodePlate.setBounds(this.getBounds());
                return this.defaultNodePlate.getPolygonPoints();
            }
            return super.getPolygonPoints();
        }
        SvgToDraw2DTransform transform = this.getTransform(this.outlineDimension.preciseWidth(), this.outlineDimension.preciseHeight(), this.getDraw2DAnchor());
        PointList points = new PointList(5);
        for (PrecisionPoint point : this.outlinePoints) {
            points.addPoint((Point)transform.transform(point));
        }
        return points;
    }

    public boolean hasLabelBounds() {
        return this.labelBounds != null;
    }

    public Rectangle getLabelBounds(Rectangle anchor) {
        if (this.labelBounds == null) {
            return null;
        }
        SvgToDraw2DTransform transform = this.getTransform(this.labelBounds.preciseRight(), this.labelBounds.preciseBottom(), anchor);
        return transform.transform(this.labelBounds);
    }

    private static class SvgToDraw2DTransform {
        private double scaleX;
        private double scaleY;
        private double translationX;
        private double translationY;

        public SvgToDraw2DTransform(double scaleX, double scaleY, double translationX, double translationY) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.translationX = translationX;
            this.translationY = translationY;
        }

        public PrecisionPoint transform(PrecisionPoint point) {
            return new PrecisionPoint(point.preciseX() * this.scaleX + this.translationX, point.preciseY() * this.scaleY + this.translationY);
        }

        public PrecisionRectangle transform(PrecisionRectangle rectangle) {
            return new PrecisionRectangle(rectangle.preciseX() * this.scaleX + this.translationX, rectangle.preciseY() * this.scaleY + this.translationY, rectangle.preciseWidth() * this.scaleX, rectangle.preciseHeight() * this.scaleY);
        }
    }
}

