/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnHeaderCheckBoxPainter
extends ImagePainter {
    private static final Log log = LogFactory.getLog(ColumnHeaderCheckBoxPainter.class);
    private final Image checkedImg;
    private final Image semicheckedImg;
    private final Image uncheckedImg;
    private final IUniqueIndexLayer columnDataLayer;

    public ColumnHeaderCheckBoxPainter(IUniqueIndexLayer columnDataLayer) {
        this(columnDataLayer, GUIHelper.getImage("checked"), GUIHelper.getImage("semichecked"), GUIHelper.getImage("unchecked"));
    }

    public ColumnHeaderCheckBoxPainter(IUniqueIndexLayer columnLayer, Image checkedImg, Image semicheckedImage, Image uncheckedImg) {
        this.columnDataLayer = columnLayer;
        this.checkedImg = checkedImg;
        this.semicheckedImg = semicheckedImage;
        this.uncheckedImg = uncheckedImg;
    }

    public int getPreferredWidth(boolean checked) {
        return this.getImage((boolean)checked).getBounds().width;
    }

    public int getPreferredHeight(boolean checked) {
        return this.getImage((boolean)checked).getBounds().height;
    }

    public void paintIconImage(GC gc, Rectangle rectangle, int yOffset, boolean checked) {
        Image checkBoxImage = this.getImage(checked);
        int x = rectangle.x + rectangle.width / 2 - checkBoxImage.getBounds().width / 2;
        gc.drawImage(checkBoxImage, x, rectangle.y + yOffset);
    }

    public Image getImage(boolean checked) {
        return checked ? this.checkedImg : this.uncheckedImg;
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        int columnPosition = LayerUtil.convertColumnPosition(cell.getLayer(), cell.getColumnPosition(), this.columnDataLayer);
        int checkedCellsCount = this.getCheckedCellsCount(columnPosition, configRegistry);
        Image result = null;
        result = checkedCellsCount > 0 ? (checkedCellsCount == this.columnDataLayer.getRowCount() ? this.checkedImg : this.semicheckedImg) : this.uncheckedImg;
        return result;
    }

    public int getCheckedCellsCount(int columnPosition, IConfigRegistry configRegistry) {
        int checkedCellsCount = 0;
        int rowPosition = 0;
        while (rowPosition < this.columnDataLayer.getRowCount()) {
            ILayerCell columnCell = this.columnDataLayer.getCellByPosition(columnPosition, rowPosition);
            if (this.isChecked(columnCell, configRegistry)) {
                ++checkedCellsCount;
            }
            ++rowPosition;
        }
        return checkedCellsCount;
    }

    protected boolean isChecked(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.convertDataType(cell, configRegistry);
    }

    protected Boolean convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        if (cell.getDataValue() instanceof Boolean) {
            return (Boolean)cell.getDataValue();
        }
        IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        Boolean convertedValue = null;
        if (displayConverter != null) {
            try {
                convertedValue = (Boolean)displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue());
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        if (convertedValue == null) {
            convertedValue = Boolean.FALSE;
        }
        return convertedValue;
    }
}

