/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ITabMouseEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabMouseEvent;
import org.eclipse.swt.events.MouseEvent;

public class TabMouseEventsProvider {
    private List<ITabMouseEventsListener> listeners = new ArrayList<ITabMouseEventsListener>();

    public void addListener(ITabMouseEventsListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(ITabMouseEventsListener listener) {
        this.listeners.remove(listener);
    }

    public void fireMouseDoubleClickEvent(PagePart page, TabFolderPart folder, MouseEvent event) {
        for (ITabMouseEventsListener listener : this.listeners) {
            listener.mouseDoubleClick(new TabMouseEvent(page, folder, event));
        }
    }

    public void fireMouseDownEvent(PagePart page, TabFolderPart folder, MouseEvent event) {
        for (ITabMouseEventsListener listener : this.listeners) {
            listener.mouseDown(new TabMouseEvent(page, folder, event));
        }
    }

    public void fireMouseUpEvent(PagePart page, TabFolderPart folder, MouseEvent event) {
        for (ITabMouseEventsListener listener : this.listeners) {
            listener.mouseUp(new TabMouseEvent(page, folder, event));
        }
    }
}

