/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.IServiceRegistryProvider;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.tools.util.IProgressCallable;

@FunctionalInterface
public interface IPapyrusCallable<V>
extends IProgressCallable<V>,
IServiceRegistryProvider {
    @Override
    default public ServicesRegistry getServiceRegistry() {
        try {
            return ServiceUtils.getInstance().getServiceRegistry(null);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static <V> IPapyrusCallable<V> inContext(final ServicesRegistry registry, final IPapyrusCallable<V> callable) {
        return new IPapyrusCallable<V>(){

            public V call(IProgressMonitor monitor) throws Exception {
                return callable.call(monitor);
            }

            @Override
            public ServicesRegistry getServiceRegistry() {
                return registry;
            }
        };
    }
}

