/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.markerlistener.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.IMarkerEventListener;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractMarkerMonitor
implements IMarkerMonitor {
    private ModelSet modelSet;
    private final CopyOnWriteArrayList<IMarkerEventListener> listeners = new CopyOnWriteArrayList();

    public void initialize(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    protected final ModelSet getModelSet() {
        return this.modelSet;
    }

    public void dispose() {
        this.listeners.clear();
        this.modelSet = null;
    }

    protected void fireMarkerAdded(final IPapyrusMarker marker) {
        if (this.listeners != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    for (IMarkerEventListener listener : AbstractMarkerMonitor.this.listeners) {
                        try {
                            listener.notifyMarkerChange(marker.getEObject(), marker, 1);
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in marker listener.", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    protected void fireMarkerRemoved(final IPapyrusMarker marker) {
        if (this.listeners != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    for (IMarkerEventListener listener : AbstractMarkerMonitor.this.listeners) {
                        try {
                            listener.notifyMarkerChange(marker.getEObject(), marker, 0);
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in marker listener.", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void addMarkerEventListener(IMarkerEventListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeMarkerEventListener(IMarkerEventListener listener) {
        this.listeners.remove(listener);
    }
}

