/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.emf.facet.efacet.core.FacetUtils;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManagerListener;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.FacetCache;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.FacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.ListUtils;
import org.eclipse.papyrus.emf.facet.util.emf.core.ModelUtils;

class FacetManagerContext
implements List<FacetSet> {
    private static final String SILENT_OPTION = "org.eclipse.papyrus.emf.facet.efacet.core.internal.FacetManagerContext.getOverrideCandidateFeatures.silent";
    private static final boolean SILENT = Boolean.getBoolean("org.eclipse.papyrus.emf.facet.efacet.core.internal.FacetManagerContext.getOverrideCandidateFeatures.silent");
    private final EList<FacetSet> managedFacetSets = new BasicEList<FacetSet>(){
        private static final long serialVersionUID = 1L;

        protected void didRemove(int index, FacetSet oldObject) {
            FacetManagerContext.this.unconfigure(oldObject);
        }

        protected void didAdd(int index, FacetSet newObject) {
            FacetManagerContext.this.configure(newObject);
        }

        protected void didSet(int index, FacetSet newObject, FacetSet oldObject) {
            FacetManagerContext.this.unconfigure(oldObject);
            FacetManagerContext.this.configure(newObject);
        }

        protected void didChange() {
            FacetManagerContext.this.facetsUpdated();
        }
    };
    private final transient FacetManager manager;
    private transient Adapter facetAdapter;
    transient long facetGeneration;
    private transient boolean updateEnabled = true;
    private final Set<ETypedElement> failingFeatures = new HashSet<ETypedElement>();
    private final Set<IFacetManagerListener> listeners = new HashSet<IFacetManagerListener>();

    public FacetManagerContext(FacetManager manager) {
        this.manager = manager;
    }

    public <T extends ETypedElement> T resolveOverrides(T baseFeature, EObject eObject) throws FacetManagerException {
        Object result = baseFeature;
        if (baseFeature instanceof DerivedTypedElement) {
            DerivedTypedElement derivedResult = this.resolveOverrides((DerivedTypedElement)baseFeature, eObject);
            if (derivedResult != null && !(derivedResult instanceof ETypedElement)) {
                throw new UnmatchingExpectedTypeException("Type mismatch in override resolution '" + baseFeature.getName() + "'");
            }
            result = derivedResult;
        }
        if (result == null) {
            result = baseFeature;
        }
        return result;
    }

    public <T extends DerivedTypedElement> T resolveOverrides(T baseFeature, EObject eObject) throws FacetManagerException {
        FacetCache cache = FacetCache.getInstance(eObject, this);
        T result = cache.resolve(baseFeature);
        if (result == null) {
            try {
                T signatureFeature = FacetUtils.getTopOverrideFeature(baseFeature);
                List<T> orderedCandidates = this.getOverrideCandidateFeatures(eObject, signatureFeature);
                result = FacetManagerContext.findMostSpecificFeature(orderedCandidates);
                cache.add(baseFeature, result);
            }
            catch (Exception e) {
                throw new FacetManagerException(e);
            }
        }
        return result;
    }

    public List<FacetSet> getManagedFacetSets() {
        return Collections.unmodifiableList(this.managedFacetSets);
    }

    public void setManagedFacetSets(List<FacetSet> facetSets) {
        boolean enableUpdate = this.updateEnabled;
        this.updateEnabled = false;
        try {
            ECollections.setEList(this.managedFacetSets, facetSets);
        }
        finally {
            this.updateEnabled = enableUpdate;
        }
        this.facetsUpdated();
    }

    public void addBackManagedFacetSet(FacetSet facetSet) {
        this.add(facetSet);
    }

    public void addFrontManagedFacetSet(FacetSet facetSet) {
        this.add(0, facetSet);
    }

    private static <T extends DerivedTypedElement> T findMostSpecificFeature(List<T> orderedCandidates) {
        DerivedTypedElement result = null;
        if (!orderedCandidates.isEmpty()) {
            Iterator<T> candidatesIt = orderedCandidates.iterator();
            result = (DerivedTypedElement)candidatesIt.next();
            while (candidatesIt.hasNext()) {
                DerivedTypedElement candidate = (DerivedTypedElement)candidatesIt.next();
                if (!FacetManagerContext.isOverridenBy(candidate, result)) continue;
                result = candidate;
            }
        }
        return (T)result;
    }

    private <T extends DerivedTypedElement> List<T> getOverrideCandidateFeatures(EObject eObject, T baseFeature) throws FacetManagerException {
        ResourceSet baserFeatureRS = baseFeature.eResource().getResourceSet();
        LinkedList<T> result = new LinkedList<T>();
        List<FacetSet> managedFSets = this.getManagedFacetSets();
        ArrayList<FacetSet> allFacetSets = new ArrayList<FacetSet>(managedFSets);
        for (FacetSet facetSet : managedFSets) {
            for (FacetSet subFacetSet : facetSet.getFacetSets()) {
                FacetSet resolvedFacetSet = IResolverManager.DEFAULT.resolve(subFacetSet, FacetSet.class);
                allFacetSets.add(resolvedFacetSet);
            }
        }
        for (FacetSet facetSet : allFacetSets) {
            Resource resource = facetSet.eResource();
            if (resource == null) {
                String message = String.format("The facetSet %s (%s) is not stored in a resource.", facetSet.getName(), facetSet.getNsURI());
                Logger.logWarning((String)message, (Plugin)Activator.getDefault());
            } else {
                ResourceSet facetSetRS = resource.getResourceSet();
                if (!facetSetRS.equals(baserFeatureRS)) {
                    Logger.logWarning((String)"The facet manager is dealing with more than one resource set.", (Plugin)Activator.getDefault());
                }
            }
            for (Facet facet : FacetUtils.getFacets(facetSet)) {
                T matchingFeature = this.getMatchingFeature(eObject, facet, baseFeature);
                if (matchingFeature == null) continue;
                result.add(matchingFeature);
            }
        }
        if (result.isEmpty()) {
            if (!this.failingFeatures.contains(baseFeature) && !SILENT) {
                Logger.logWarning((String)("The result of " + this.getClass().getSimpleName() + ".getOverrideCandidateFeatures(...) is empty! baseFeature=" + EcoreUtil.getURI(baseFeature) + " (This message will be sent only once)"), (Plugin)Activator.getDefault());
                this.failingFeatures.add((ETypedElement)baseFeature);
            }
            result.add(baseFeature);
        }
        return result;
    }

    private static boolean isOverridenBy(DerivedTypedElement child, DerivedTypedElement targetParent) {
        boolean result = false;
        if (child.equals(targetParent)) {
            result = true;
        } else {
            DerivedTypedElement currentParent = child.getOverride();
            while (!result && currentParent != null) {
                if (currentParent.equals(targetParent)) {
                    result = true;
                    continue;
                }
                currentParent = currentParent.getOverride();
            }
        }
        return result;
    }

    private <T extends DerivedTypedElement> T getMatchingFeature(EObject eObject, Facet facet, T signatureFeature) throws FacetManagerException {
        DerivedTypedElement result = null;
        EList eTypedElements = signatureFeature instanceof EOperation ? facet.getFacetOperations() : facet.getFacetElements();
        for (ETypedElement feature : eTypedElements) {
            DerivedTypedElement tmpFeature;
            FacetManager.ConformanceState conformanceState;
            if (!FacetManagerContext.isMatchingFeature2(signatureFeature, feature) || (conformanceState = this.manager.getConformanceState(eObject, facet)) != FacetManager.ConformanceState.Conformant) continue;
            if (!signatureFeature.getClass().isInstance(feature)) {
                throw new FacetManagerException(String.valueOf(ModelUtils.getQualifiedName((ENamedElement)feature)) + " overrides " + ModelUtils.getQualifiedName(signatureFeature) + " but both are not of the same kind.");
            }
            result = tmpFeature = (DerivedTypedElement)feature;
            break;
        }
        return (T)result;
    }

    private static <T extends DerivedTypedElement> boolean isMatchingFeature2(T signatureFeature, ETypedElement feature) throws FacetManagerException {
        boolean result = false;
        if (signatureFeature.getClass().isInstance(feature)) {
            DerivedTypedElement element = (DerivedTypedElement)feature;
            DerivedTypedElement topFeature = FacetUtils.getTopOverrideFeature(element);
            if (topFeature == signatureFeature) {
                result = true;
            } else {
                Resource topResource = topFeature.eResource();
                Resource signatureResource = signatureFeature.eResource();
                if (topResource == null || signatureResource == null || topFeature.eResource().getResourceSet() != signatureFeature.eResource().getResourceSet()) {
                    Logger.logWarning((String)"topOverrideFeature.eResource().getResourceSet() != signatureFeature.eResource().getResourceSet()", (Plugin)Activator.getDefault());
                }
            }
        }
        return result;
    }

    public void removeFacetSet(FacetSet facetSet) {
        this.managedFacetSets.remove((Object)facetSet);
    }

    @Override
    public void clear() {
        this.managedFacetSets.clear();
    }

    @Override
    public int size() {
        return this.managedFacetSets.size();
    }

    @Override
    public boolean isEmpty() {
        return this.managedFacetSets.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.managedFacetSets.contains(object);
    }

    @Override
    public Iterator<FacetSet> iterator() {
        return this.managedFacetSets.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.managedFacetSets.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.managedFacetSets.toArray((Object[])array);
    }

    @Override
    public boolean add(FacetSet object) {
        boolean result = false;
        if (object != null) {
            int existing = this.managedFacetSets.indexOf((Object)object);
            int last = this.size() - 1;
            if (existing >= 0) {
                if (existing != last) {
                    this.managedFacetSets.move(last, existing);
                    result = true;
                }
            } else {
                result = this.managedFacetSets.add((Object)object);
            }
        }
        return result;
    }

    @Override
    public boolean remove(Object object) {
        return this.managedFacetSets.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.managedFacetSets.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends FacetSet> collection) {
        boolean result;
        boolean enableUpdate = this.updateEnabled;
        this.updateEnabled = false;
        try {
            boolean removed = this.managedFacetSets.removeAll(collection);
            boolean added = this.managedFacetSets.addAll(collection);
            result = removed || added;
        }
        finally {
            this.updateEnabled = enableUpdate;
        }
        if (result) {
            this.facetsUpdated();
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends FacetSet> collection) {
        boolean bl;
        ArrayList<FacetSet> filtered = new ArrayList<FacetSet>();
        for (FacetSet facetSet : collection) {
            if (filtered.contains(facetSet)) continue;
            filtered.add(facetSet);
        }
        boolean enableUpdate = this.updateEnabled;
        this.updateEnabled = false;
        try {
            boolean removed = this.managedFacetSets.removeAll(filtered);
            boolean added = this.managedFacetSets.addAll(index, (Collection)ListUtils.cleanList(filtered));
            bl = removed || added;
        }
        finally {
            this.updateEnabled = enableUpdate;
        }
        if (bl) {
            this.facetsUpdated();
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.managedFacetSets.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.managedFacetSets.retainAll(collection);
    }

    @Override
    public FacetSet get(int index) {
        return (FacetSet)this.managedFacetSets.get(index);
    }

    @Override
    public FacetSet set(int index, FacetSet element) {
        return (FacetSet)this.managedFacetSets.set(index, (Object)element);
    }

    @Override
    public void add(int index, FacetSet element) {
        if (element != null) {
            int existing = this.managedFacetSets.indexOf((Object)element);
            if (existing >= 0) {
                if (existing != index) {
                    this.managedFacetSets.move(index, existing);
                }
            } else {
                this.managedFacetSets.add(index, (Object)element);
            }
        }
    }

    @Override
    public FacetSet remove(int index) {
        return (FacetSet)this.managedFacetSets.remove(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.managedFacetSets.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.managedFacetSets.lastIndexOf(object);
    }

    @Override
    public ListIterator<FacetSet> listIterator() {
        return this.managedFacetSets.listIterator();
    }

    @Override
    public ListIterator<FacetSet> listIterator(int index) {
        return this.managedFacetSets.listIterator(index);
    }

    @Override
    public List<FacetSet> subList(int fromIndex, int toIndex) {
        return this.subList(fromIndex, toIndex);
    }

    public void addListener(IFacetManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IFacetManagerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IFacetManagerListener listener : this.listeners) {
            listener.facetManagerChanged();
        }
    }

    private void facetsUpdated() {
        if (this.updateEnabled) {
            this.incrementGeneration();
            this.notifyListeners();
        }
    }

    private void incrementGeneration() {
        ++this.facetGeneration;
    }

    private FacetSet configure(FacetSet facetSet) {
        if (facetSet != null && !facetSet.eAdapters().contains((Object)this.getFacetSetAdapter())) {
            facetSet.eAdapters().add((Object)this.getFacetSetAdapter());
        }
        return facetSet;
    }

    private <T> T unconfigure(T facetSet) {
        if (facetSet instanceof FacetSet) {
            ((FacetSet)facetSet).eAdapters().remove((Object)this.getFacetSetAdapter());
        }
        return facetSet;
    }

    private Adapter getFacetSetAdapter() {
        if (this.facetAdapter == null) {
            this.facetAdapter = new EContentAdapter(){

                protected void selfAdapt(Notification notification) {
                    if (!notification.isTouch()) {
                        FacetManagerContext.this.incrementGeneration();
                    }
                    super.selfAdapt(notification);
                }
            };
        }
        return this.facetAdapter;
    }
}

