/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.internal.ui.handlers;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.types.core.internal.ui.providers.ClientContextContentProvider;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class DeployElementTypeSetConfigurationHandler
extends AbstractHandler
implements IHandler {
    protected IClientContext clientContext;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        final IStructuredSelection selection = (IStructuredSelection)currentSelection;
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        activeShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object selectedClientContext;
                ListSelectionDialog dialog = new ListSelectionDialog(activeShell, (Object)ClientContextManager.getInstance().getClientContexts(), (IStructuredContentProvider)new ClientContextContentProvider(), (ILabelProvider)new LabelProvider(), "Select the clientContext you want to register the elementtypesconfiguration to");
                dialog.open();
                Object[] clientContextSelection = dialog.getResult();
                if (clientContextSelection != null && clientContextSelection.length > 0 && (selectedClientContext = clientContextSelection[0]) instanceof IClientContext) {
                    DeployElementTypeSetConfigurationHandler.this.clientContext = (IClientContext)selectedClientContext;
                }
            }
        });
        if (this.clientContext == null) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.infra.types.core", "The elementTypes configuration has not been loaded"), 2);
        }
        Job job = new Job("Deploy elementTypes set configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Deploying selected configurations", selection.size());
                return DeployElementTypeSetConfigurationHandler.this.doExecute(selection, monitor);
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                activeShell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult().isOK()) {
                            MessageDialog.openInformation((Shell)activeShell, (String)"Success", (String)event.getResult().getMessage());
                        } else if (event.getResult().getSeverity() < 4) {
                            StatusManager.getManager().handle(event.getResult(), 2);
                        }
                    }
                });
            }
        });
        job.setUser(true);
        job.schedule();
        return null;
    }

    protected IStatus doExecute(IStructuredSelection selection, IProgressMonitor monitor) {
        Iterator selectionIterator = selection.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.papyrus.infra.types.core", 0, "The elementTypes configuration has been successfully deployed and activated", null);
        while (selectionIterator.hasNext()) {
            Object selectedElement = selectionIterator.next();
            if (!(selectedElement instanceof IAdaptable)) continue;
            IFile selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class);
            if (selectedFile == null) {
                monitor.worked(1);
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.types.core", "The selected element is not a file"));
                continue;
            }
            String fileName = selectedFile.getFullPath().removeFileExtension().lastSegment();
            monitor.subTask("Deploy " + fileName);
            ElementTypeSetConfigurationRegistry.getInstance().loadElementTypeSetConfiguration(this.clientContext.getId(), selectedFile.getFullPath().toString());
            monitor.worked(1);
            result.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.types.core", "The elementTypes configuration has been loaded"));
        }
        if (result.getChildren().length == 1) {
            return result.getChildren()[0];
        }
        if (result.isOK()) {
            return result;
        }
        MultiStatus actualResult = new MultiStatus("org.eclipse.papyrus.infra.types.core", result.getCode(), "Some errors occurred during the deployment", result.getException());
        actualResult.merge((IStatus)result);
        return actualResult;
    }
}

