/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;

public class ElementTypesFileChecker
implements IPluginChecker {
    private final IFile elementTypesFile;
    private final Resource resource;

    public ElementTypesFileChecker(IFile elementTypesFile, Resource resource) {
        this.elementTypesFile = elementTypesFile;
        this.resource = resource;
    }

    public void check(IProgressMonitor monitor) {
        Diagnostic diagnostic;
        if (monitor != null) {
            monitor.subTask("Validate element types file '" + this.elementTypesFile.getName() + "'.");
        }
        if ((diagnostic = Diagnostician.INSTANCE.validate((EObject)this.resource.getContents().get(0))).getSeverity() != 0) {
            for (Diagnostic child : diagnostic.getChildren()) {
                int severity = child.getSeverity() == 4 ? 2 : (child.getSeverity() == 2 ? 1 : 0);
                MarkersService.createMarker((IResource)this.elementTypesFile, (String)"org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", (String)child.getMessage(), (int)severity);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

