/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.services.decoration.IDecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.validation.preferences.PreferenceUtils;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationFunctions
implements IDecorationSpecificFunctions {
    public static final String error_co = "icons/etool16/error_co.gif";
    public static final String warning_co = "icons/etool16/warning_co.gif";
    public static final String info_co = "icons/etool16/info_co.gif";

    public ImageDescriptor getImageDescriptorForGE(IPapyrusMarker marker) {
        int severity = marker.getAttribute("severity", -1);
        return this.getImageDescriptorForGE(severity);
    }

    public ImageDescriptor getImageDescriptorForGE(int severity) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor overlay = null;
        switch (severity) {
            case 2: {
                overlay = sharedImages.getImageDescriptor("IMG_OBJS_ERROR_TSK");
                break;
            }
            case 1: {
                overlay = sharedImages.getImageDescriptor("IMG_OBJS_WARN_TSK");
                break;
            }
            case 0: {
                overlay = sharedImages.getImageDescriptor("IMG_OBJS_INFO_TSK");
            }
        }
        return overlay;
    }

    public ImageDescriptor getImageDescriptorForME(IPapyrusMarker marker) {
        int severity = marker.getAttribute("severity", -1);
        return this.getImageDescriptorForME(severity);
    }

    public ImageDescriptor getImageDescriptorForME(int severity) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor overlay = null;
        Activator widgetsActivator = Activator.getDefault();
        switch (severity) {
            case 2: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_ERROR");
                if (overlay != null) break;
                overlay = widgetsActivator.getImageDescriptor("org.eclipse.papyrus.infra.services.validation", error_co);
                break;
            }
            case 1: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_WARNING");
                if (overlay != null) break;
                overlay = widgetsActivator.getImageDescriptor("org.eclipse.papyrus.infra.services.validation", warning_co);
                break;
            }
            case 0: {
                overlay = widgetsActivator.getImageDescriptor("org.eclipse.papyrus.infra.services.validation", info_co);
            }
        }
        return overlay;
    }

    public Decoration.PreferedPosition getPreferedPosition(IPapyrusMarker marker) {
        return Decoration.PreferedPosition.SOUTH_WEST;
    }

    public String getMessage(IPapyrusMarker marker) {
        return marker.getAttribute("message", "");
    }

    public int getPriority(IPapyrusMarker marker) {
        return marker.getAttribute("severity", -1);
    }

    public IDecorationSpecificFunctions.MarkChildren supportsMarkerPropagation() {
        return PreferenceUtils.getHierarchicalMarkers();
    }

    public IPapyrusDecoration markerPropagation(EList<IPapyrusDecoration> childDecorations) {
        int childWarnings = 0;
        int childErrors = 0;
        for (IPapyrusDecoration childDecoration : childDecorations) {
            if (childDecoration.getDecorationImageForME() == this.getImageDescriptorForME(1)) {
                ++childWarnings;
                continue;
            }
            if (childDecoration.getDecorationImageForME() != this.getImageDescriptorForME(2)) continue;
            ++childErrors;
        }
        if (childWarnings > 0 || childErrors > 0) {
            String message = "";
            int childSeverity = 0;
            String msgErrors = String.valueOf(childErrors) + " error(s)";
            String msgWarnings = String.valueOf(childWarnings) + " warnings(s)";
            if (childErrors > 0 && childWarnings > 0) {
                message = String.valueOf(msgErrors) + " and " + msgWarnings;
                childSeverity = 2;
            } else if (childErrors > 0) {
                message = msgErrors;
                childSeverity = 2;
            } else if (childWarnings > 0) {
                message = msgWarnings;
                childSeverity = 1;
            }
            message = String.valueOf(message) + " in the children";
            Decoration deco = new Decoration(null, "org.eclipse.emf.ecore.diagnostic", this.getImageDescriptorForGE(childSeverity), this.getImageDescriptorForME(childSeverity), message, null, childSeverity);
            deco.setPosition(Decoration.PreferedPosition.NORTH_WEST);
            return deco;
        }
        return null;
    }
}

