/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.dialogs;

import com.swtdesigner.ResourceManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.papyrus.uml.search.ui.CheckBoxFilteredTree;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.filters.TypesMatchFilter;
import org.eclipse.papyrus.uml.search.ui.providers.FilterTypeContentProvider;
import org.eclipse.papyrus.uml.search.ui.providers.FilterTypeLabelProvider;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PatternFilter;

public class TypesFilterDialog
extends Dialog {
    private CheckBoxFilteredTree filterTypesTree;
    private AbstractTextSearchViewPage fPage;
    private CheckboxTreeViewer filterTypesTreeViewer;

    public TypesFilterDialog(Shell parentShell, AbstractTextSearchViewPage page) {
        super(parentShell);
        this.fPage = page;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TypesFilterDialog_0);
        shell.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.uml.search.ui", "icons/filter.png"));
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.filterTypesTree = new CheckBoxFilteredTree(parent, 2816, new PatternFilter(), true);
        this.filterTypesTree.setLayoutData(new GridData(4, 4, true, true, 0, 0));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.filterTypesTreeViewer = (CheckboxTreeViewer)this.filterTypesTree.getViewer();
        this.filterTypesTreeViewer.setContentProvider((IContentProvider)new FilterTypeContentProvider());
        this.filterTypesTreeViewer.setLabelProvider((IBaseLabelProvider)new FilterTypeLabelProvider());
        this.filterTypesTreeViewer.setInput((Object)this.fPage.getInput());
        this.filterTypesTreeViewer.setAllChecked(true);
        return parent;
    }

    protected void okPressed() {
        TypesMatchFilter typeFilter = new TypesMatchFilter(this.filterTypesTreeViewer.getCheckedElements());
        MatchFilter[] filters = new MatchFilter[]{typeFilter};
        AbstractTextSearchResult input = this.fPage.getInput();
        if (input instanceof PapyrusSearchResult) {
            input.setActiveMatchFilters(filters);
            ((PapyrusSearchResult)input).setPossibleMatchFilter(filters);
        }
        super.okPressed();
    }
}

