/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.ecore.plugin.RegistryReader;

public class OneTimeRegistryReader
extends RegistryReader {
    private static Class<?>[] REGISTRY_API = new Class[]{IExtensionRegistry.class};
    private static Set<String> ADD_LISTENER_METHOD_NAMES = ImmutableSet.of((Object)"addListener", (Object)"addRegistryChangeListener");

    public OneTimeRegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
        super(OneTimeRegistryReader.wrap(pluginRegistry), pluginID, extensionPointID);
    }

    private static IExtensionRegistry wrap(final IExtensionRegistry pluginRegistry) {
        return (IExtensionRegistry)Proxy.newProxyInstance(OneTimeRegistryReader.class.getClassLoader(), REGISTRY_API, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!OneTimeRegistryReader.isAddListenerMethod(method)) {
                    return method.invoke((Object)pluginRegistry, args);
                }
                return null;
            }
        });
    }

    static boolean isAddListenerMethod(Method method) {
        return IExtensionRegistry.class.isAssignableFrom(method.getDeclaringClass()) && ADD_LISTENER_METHOD_NAMES.contains(method.getName());
    }
}

