/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RenamedElementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IGraphicalEditPart> selection = this.getSelectedElements();
        selection.get(0).performRequest(new Request((Object)"direct edit"));
        return null;
    }

    public boolean isEnabled() {
        List<IGraphicalEditPart> selection = this.getSelectedElements();
        if (selection.size() == 1) {
            IGraphicalEditPart editpart = selection.get(0);
            DiagramEditPart diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)editpart);
            EObject modelElement = EMFHelper.getEObject((Object)editpart);
            return editpart != diagramEP && (modelElement == null || !EMFHelper.isReadOnly((EObject)modelElement));
        }
        return false;
    }

    protected List<IGraphicalEditPart> getSelectedElements() {
        ArrayList<IGraphicalEditPart> editparts = new ArrayList<IGraphicalEditPart>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object object : structuredSelection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    editparts.add((IGraphicalEditPart)object);
                }
            } else if (selection instanceof IGraphicalEditPart) {
                editparts.add((IGraphicalEditPart)selection);
            }
        }
        return editparts;
    }
}

