/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.creation;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;
import org.eclipse.papyrus.infra.properties.ui.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CreateInDialog
extends TrayDialog {
    protected IStaticContentProvider containerContentProvider;
    protected IStaticContentProvider referenceContentProvider;
    protected ILabelProvider containerLabelProvider;
    protected ILabelProvider referenceLabelProvider;
    protected String title;
    protected EObject container;
    protected EReference containmentReference;
    protected ReferenceDialog referenceDialog;
    protected Object input;

    public CreateInDialog(Shell parentShell, Object input) {
        super(parentShell);
        this.input = input;
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.getShell().setImage(Activator.getDefault().getImage("org.eclipse.papyrus.infra.widgets", "icons/papyrus.png"));
        Label label = new Label(this.getDialogArea(), 0);
        label.setText("Choose the parent element for the new object:");
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 5;
        data.verticalIndent = 5;
        label.setLayoutData((Object)data);
        final ReferenceDialog containerDialog = new ReferenceDialog(this.getDialogArea(), 0);
        containerDialog.setLabel("Container : ");
        containerDialog.setLabelProvider(this.containerLabelProvider);
        containerDialog.setContentProvider(this.containerContentProvider);
        containerDialog.setInput(this.input);
        this.referenceDialog = new ReferenceDialog(this.getDialogArea(), 0);
        this.referenceDialog.setLabel("Reference : ");
        this.referenceDialog.setLabelProvider(this.referenceLabelProvider);
        this.referenceDialog.setContentProvider(this.referenceContentProvider);
        containerDialog.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                CreateInDialog.this.container = (EObject)containerDialog.getValue();
                CreateInDialog.this.referenceDialog.setInput((Object)CreateInDialog.this.container);
                CreateInDialog.this.referenceContentProvider.inputChanged(null, null, (Object)CreateInDialog.this.container);
                if (CreateInDialog.this.referenceContentProvider.getElements().length == 0) {
                    CreateInDialog.this.referenceDialog.setValue(null);
                } else if (CreateInDialog.this.referenceContentProvider.getElements().length == 1) {
                    CreateInDialog.this.referenceDialog.setValue(CreateInDialog.this.referenceContentProvider.getElements()[0]);
                } else if (!Arrays.asList(CreateInDialog.this.referenceContentProvider.getElements()).contains(CreateInDialog.this.referenceDialog.getValue())) {
                    CreateInDialog.this.referenceDialog.setValue(null);
                }
                CreateInDialog.this.updateControls();
            }
        });
        this.referenceDialog.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                CreateInDialog.this.containmentReference = (EReference)CreateInDialog.this.referenceDialog.getValue();
                CreateInDialog.this.updateControls();
            }
        });
        this.updateControls();
        this.getShell().setSize(450, 180);
    }

    protected void updateControls() {
        this.referenceDialog.setReadOnly(this.referenceContentProvider.getElements().length < 2);
        if (this.container == null || this.containmentReference == null) {
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(this.container.eClass().getEAllReferences().contains((Object)this.containmentReference));
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public EObject getContainer() {
        return this.container;
    }

    public EReference getContainmentReference() {
        return this.containmentReference;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new PropertiesLayout(true));
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    public void setProviders(IStaticContentProvider containerContentProvider, IStaticContentProvider referenceContentProvider, ILabelProvider containerLabelProvider, ILabelProvider referenceLabelProvider) {
        this.containerContentProvider = containerContentProvider;
        this.referenceContentProvider = referenceContentProvider;
        this.containerLabelProvider = containerLabelProvider;
        this.referenceLabelProvider = referenceLabelProvider;
    }
}

