/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.uml.diagram.activity.helper.PinAndParameterSynchronizeValidator;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValuePin;
import org.eclipse.uml2.uml.ValueSpecification;

public class UMLValidationHelper {
    private static final String EXCEPTION_HANDLER_CONSTRAINT_2 = "An edge that has a source in an exception handler structured node must also have its target in the handler, and vice versa.";
    private static final String EXCEPTION_HANDLER_CONSTRAINT_3 = "If the protected node is a StructuredActivityNode with output pins, then the exception handler body must also be a StructuredActivityNode with output pins that correspond in number and types to those of the protected node.";
    private static final String EXCEPTION_HANDLER_CONSTRAINT_4 = "The handler body has one input, and that input is the same as the exception input";
    private static final String EXCEPTION_HANDLER_CONSTRAINT_1 = "The exception handler and its input object node are not the source or target of any edge.";

    public static IStatus validateSourceAndTarget(ActivityEdge context, IValidationContext ctx) {
        Activity edgeActivity = context.getActivity();
        if (edgeActivity == null) {
            Element edgeOwner = context.getOwner();
            while (edgeOwner != null && !(edgeOwner instanceof Activity)) {
                edgeOwner = edgeOwner.getOwner();
            }
            if (edgeOwner instanceof Activity) {
                edgeActivity = (Activity)edgeOwner;
            } else {
                return ctx.createSuccessStatus();
            }
        }
        ActivityNode source = context.getSource();
        ActivityNode target = context.getTarget();
        if (source != null && target != null) {
            Activity targetActivity;
            Activity sourceActivity = source.getActivity();
            if (sourceActivity == null) {
                Element sourceOwner = source.getOwner();
                while (sourceOwner != null && !(sourceOwner instanceof Activity)) {
                    sourceOwner = sourceOwner.getOwner();
                }
                if (sourceOwner instanceof Activity) {
                    sourceActivity = (Activity)sourceOwner;
                } else {
                    return ctx.createSuccessStatus();
                }
            }
            if ((targetActivity = target.getActivity()) == null) {
                Element targetOwner = target.getOwner();
                while (targetOwner != null && !(targetOwner instanceof Activity)) {
                    targetOwner = targetOwner.getOwner();
                }
                if (targetOwner instanceof Activity) {
                    targetActivity = (Activity)targetOwner;
                } else {
                    return ctx.createSuccessStatus();
                }
            }
            if (!edgeActivity.equals(sourceActivity) || !edgeActivity.equals(targetActivity)) {
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateInterruptibleEdge(ActivityEdge context, IValidationContext ctx) {
        return UMLValidationHelper.validateInterruptibleEdge(context, context.getInterrupts()) ? ctx.createSuccessStatus() : ctx.createFailureStatus(new Object[]{"Interrupting edges of a region must have their source node in the region and their target node outside the region in the same activity containing the region."});
    }

    public static IStatus validateException_StructuredActivityNode_Constraint2(ActivityEdge context, IValidationContext ctx) {
        StructuredActivityNode inStrucActNode;
        ActivityNode source = context.getSource();
        ActivityNode target = context.getTarget();
        if (source != null && target != null && ((inStrucActNode = source.getInStructuredNode()) != null ? !inStrucActNode.equals(target.getInStructuredNode()) : target.getInStructuredNode() != null)) {
            return ctx.createFailureStatus(new Object[]{EXCEPTION_HANDLER_CONSTRAINT_2});
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateException_HandlerBody_Constraint4(ExceptionHandler context, IValidationContext ctx) {
        Action handlerBodyAction;
        ExecutableNode handlerBody = context.getHandlerBody();
        if (handlerBody != null && handlerBody instanceof Action && ((handlerBodyAction = (Action)handlerBody).getInputs() == null || handlerBodyAction.getInputs().size() != 1)) {
            return ctx.createFailureStatus(new Object[]{EXCEPTION_HANDLER_CONSTRAINT_4});
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateException_SourceAndTargetEdge_Constraint1(ExceptionHandler context, IValidationContext ctx) {
        ObjectNode exceptionInput = context.getExceptionInput();
        if (exceptionInput != null) {
            EList incominEdges = exceptionInput.getIncomings();
            EList outgoingEdges = exceptionInput.getOutgoings();
            if (incominEdges != null && incominEdges.size() != 0 || outgoingEdges != null && outgoingEdges.size() != 0) {
                return ctx.createFailureStatus(new Object[]{EXCEPTION_HANDLER_CONSTRAINT_1});
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateException_StructuredActivityNode_Constraint3(ExceptionHandler context, IValidationContext ctx) {
        ExecutableNode protectedNode = context.getProtectedNode();
        ExecutableNode handlerBody = context.getHandlerBody();
        if (protectedNode != null && handlerBody != null && protectedNode instanceof StructuredActivityNode) {
            StructuredActivityNode structuredActNode = (StructuredActivityNode)protectedNode;
            if (handlerBody instanceof StructuredActivityNode) {
                EList protectedNodeOutputPin = structuredActNode.getOutputs();
                EList handlerBodyOutputPin = ((StructuredActivityNode)handlerBody).getOutputs();
                if (protectedNodeOutputPin.size() != handlerBodyOutputPin.size()) {
                    return ctx.createFailureStatus(new Object[]{EXCEPTION_HANDLER_CONSTRAINT_3});
                }
                int i = 0;
                while (i < protectedNodeOutputPin.size()) {
                    OutputPin outputPin = (OutputPin)protectedNodeOutputPin.get(i);
                    if (outputPin != null && outputPin.equals(handlerBodyOutputPin.get(i))) {
                        return ctx.createFailureStatus(new Object[]{EXCEPTION_HANDLER_CONSTRAINT_3});
                    }
                    ++i;
                }
            } else if (handlerBody != null) {
                return ctx.createFailureStatus(new Object[]{EXCEPTION_HANDLER_CONSTRAINT_3});
            }
        }
        return ctx.createSuccessStatus();
    }

    public static boolean validateInterruptibleEdge(ActivityEdge context, InterruptibleActivityRegion interrupts) {
        if (interrupts != null) {
            ActivityNode source = context.getSource();
            boolean validSource = false;
            while (source instanceof ActivityNode && !validSource) {
                if (source.getInInterruptibleRegions().contains((Object)interrupts)) {
                    validSource = true;
                }
                source = source.getOwner();
            }
            if (!validSource) {
                return false;
            }
            ActivityNode target = context.getTarget();
            while (target instanceof ActivityNode) {
                if (target.getInInterruptibleRegions().contains((Object)interrupts)) {
                    return false;
                }
                target = target.getOwner();
            }
        }
        return true;
    }

    public static IStatus validateCompatibleTypes(ObjectFlow context, IValidationContext ctx) {
        if (context.getTransformation() == null) {
            List<Type> srcTypes = UMLValidationHelper.getUpstreamExpectedTypes(context, new LinkedList<ObjectFlow>());
            for (Type srcType : srcTypes) {
                for (Type targetType : UMLValidationHelper.getDownstreamExpectedTypes(context, new LinkedList<ObjectFlow>())) {
                    if (UMLValidationHelper.isSuperType(targetType, srcType)) continue;
                    return ctx.createFailureStatus(new Object[0]);
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateSameUpperBounds(ObjectFlow context, IValidationContext ctx) {
        ActivityNode source = context.getSource();
        if (source instanceof ObjectNode) {
            ValueSpecification srcUpper = ((ObjectNode)source).getUpperBound();
            for (ObjectNode targetNode : UMLValidationHelper.getDownStreamObjectNodes(context)) {
                ValueSpecification targetUpper = targetNode.getUpperBound();
                if (EcoreUtil.equals((EObject)srcUpper, (EObject)targetUpper)) continue;
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateTarget(ObjectFlow context, IValidationContext ctx) {
        int weight;
        block6: {
            weight = 0;
            try {
                if (context.getWeight() != null) {
                    weight = context.getWeight().integerValue();
                    break block6;
                }
                return ctx.createSuccessStatus();
            }
            catch (UnsupportedOperationException noValueExc) {
                return ctx.createSuccessStatus();
            }
        }
        for (ObjectNode targetNode : UMLValidationHelper.getDownStreamObjectNodes(context)) {
            int targetUpper = 0;
            try {
                if (targetNode.getUpperBound() == null) continue;
                targetUpper = targetNode.getUpperBound().integerValue();
            }
            catch (UnsupportedOperationException noValueExc) {
                continue;
            }
            if (targetUpper >= weight) continue;
            return ctx.createFailureStatus(new Object[0]);
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateTransformationBehaviour(ObjectFlow context, IValidationContext ctx) {
        Behavior transformation = context.getTransformation();
        if (transformation != null) {
            int numberIn = 0;
            int numberOut = 0;
            Parameter paramIn = null;
            Parameter paramOut = null;
            for (Parameter param : transformation.getOwnedParameters()) {
                switch (param.getDirection()) {
                    case IN_LITERAL: {
                        ++numberIn;
                        paramIn = param;
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        ++numberOut;
                        paramOut = param;
                        break;
                    }
                    case INOUT_LITERAL: {
                        ++numberIn;
                        paramIn = param;
                        ++numberOut;
                        paramOut = param;
                    }
                }
            }
            if (numberIn != 1 || numberOut != 1) {
                return ctx.createFailureStatus(new Object[0]);
            }
            List<Type> srcTypes = UMLValidationHelper.getUpstreamExpectedTypes(context, new LinkedList<ObjectFlow>());
            for (Type typeToCheck : srcTypes) {
                if (UMLValidationHelper.isSuperType(paramIn.getType(), typeToCheck)) continue;
                ctx.createFailureStatus(new Object[0]);
            }
            List<Type> targetTypes = UMLValidationHelper.getDownstreamExpectedTypes(context, new LinkedList<ObjectFlow>());
            for (Type typeToCheck : targetTypes) {
                if (UMLValidationHelper.isSuperType(typeToCheck, paramOut.getType())) continue;
                ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateInputAndOutputParameter(ObjectFlow context, IValidationContext ctx) {
        Behavior selection = context.getSelection();
        if (selection != null) {
            int numberIn = 0;
            int numberOut = 0;
            Parameter paramIn = null;
            Parameter paramOut = null;
            for (Parameter param : selection.getOwnedParameters()) {
                switch (param.getDirection()) {
                    case IN_LITERAL: {
                        ++numberIn;
                        paramIn = param;
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        ++numberOut;
                        paramOut = param;
                        break;
                    }
                    case INOUT_LITERAL: {
                        ++numberIn;
                        paramIn = param;
                        ++numberOut;
                        paramOut = param;
                    }
                }
            }
            if (numberIn != 1 || numberOut != 1) {
                return ctx.createFailureStatus(new Object[0]);
            }
            List<Type> srcTypes = UMLValidationHelper.getUpstreamExpectedTypes(context, new LinkedList<ObjectFlow>());
            for (Type typeToCheck : srcTypes) {
                if (UMLValidationHelper.isSuperType(paramIn.getType(), typeToCheck)) continue;
                ctx.createFailureStatus(new Object[0]);
            }
            List<Type> targetTypes = UMLValidationHelper.getDownstreamExpectedTypes(context, new LinkedList<ObjectFlow>());
            for (Type typeToCheck : targetTypes) {
                if (UMLValidationHelper.isSuperType(typeToCheck, paramOut.getType())) continue;
                ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateCompatibleType(ValuePin context, IValidationContext ctx) {
        ValueSpecification value = context.getValue();
        if (value != null && !UMLValidationHelper.isSuperType(context.getType(), value.getType())) {
            return ctx.createFailureStatus(new Object[0]);
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateIncomingObjectOneInputParameter(DecisionNode context, IValidationContext ctx) {
        Behavior behavior = context.getDecisionInput();
        if (behavior != null) {
            ObjectFlow decisionInputFlow = context.getDecisionInputFlow();
            ActivityEdge incomingObjectFlow = context.getIncoming(null, true, UMLPackage.eINSTANCE.getObjectFlow());
            if (decisionInputFlow == null && incomingObjectFlow != null) {
                ObjectFlow inFlow = (ObjectFlow)incomingObjectFlow;
                boolean parameterFound = false;
                for (Parameter param : behavior.getOwnedParameters()) {
                    if (!ParameterDirectionKind.IN_LITERAL.equals((Object)param.getDirection())) continue;
                    if (!parameterFound) {
                        List<Type> types = UMLValidationHelper.getTypeComingFromFlow(inFlow, new LinkedList<ObjectFlow>());
                        for (Type comingType : types) {
                            if (UMLValidationHelper.isSuperType(param.getType(), comingType)) continue;
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        continue;
                    }
                    return ctx.createFailureStatus(new Object[0]);
                }
                if (!parameterFound) {
                    return ctx.createFailureStatus(new Object[0]);
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateIncomingControlOneInputParameter(DecisionNode context, IValidationContext ctx) {
        Behavior behavior = context.getDecisionInput();
        if (behavior != null) {
            ObjectFlow decisionInputFlow = context.getDecisionInputFlow();
            ActivityEdge incomingControlFlow = context.getIncoming(null, true, UMLPackage.eINSTANCE.getControlFlow());
            if (decisionInputFlow != null && incomingControlFlow != null) {
                boolean parameterFound = false;
                for (Parameter param : behavior.getOwnedParameters()) {
                    if (!ParameterDirectionKind.IN_LITERAL.equals((Object)param.getDirection())) continue;
                    if (!parameterFound) {
                        List<Type> types = UMLValidationHelper.getTypeComingFromFlow(decisionInputFlow, new LinkedList<ObjectFlow>());
                        for (Type comingType : types) {
                            if (UMLValidationHelper.isSuperType(param.getType(), comingType)) continue;
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        parameterFound = true;
                        continue;
                    }
                    return ctx.createFailureStatus(new Object[0]);
                }
                if (!parameterFound) {
                    return ctx.createFailureStatus(new Object[0]);
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateTwoInputParameters(DecisionNode context, IValidationContext ctx) {
        Behavior behavior = context.getDecisionInput();
        if (behavior != null) {
            ObjectFlow decisionInputFlow = context.getDecisionInputFlow();
            ActivityEdge incomingObjectFlow = null;
            for (ActivityEdge incomingEdge : context.getIncomings()) {
                if (!(incomingEdge instanceof ObjectFlow) || incomingEdge == decisionInputFlow) continue;
                incomingObjectFlow = incomingEdge;
            }
            if (decisionInputFlow != null && incomingObjectFlow != null) {
                ObjectFlow inFlow = (ObjectFlow)incomingObjectFlow;
                int numberOfParameterFound = 0;
                for (Parameter param : behavior.getOwnedParameters()) {
                    List<Type> types;
                    if (!ParameterDirectionKind.IN_LITERAL.equals((Object)param.getDirection())) continue;
                    if (numberOfParameterFound == 0) {
                        types = UMLValidationHelper.getTypeComingFromFlow(inFlow, new LinkedList<ObjectFlow>());
                        for (Type comingType : types) {
                            if (UMLValidationHelper.isSuperType(param.getType(), comingType)) continue;
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        ++numberOfParameterFound;
                        continue;
                    }
                    if (numberOfParameterFound == 1) {
                        types = UMLValidationHelper.getTypeComingFromFlow(decisionInputFlow, new LinkedList<ObjectFlow>());
                        for (Type comingType : types) {
                            if (UMLValidationHelper.isSuperType(param.getType(), comingType)) continue;
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        ++numberOfParameterFound;
                        continue;
                    }
                    return ctx.createFailureStatus(new Object[0]);
                }
                if (numberOfParameterFound < 2) {
                    return ctx.createFailureStatus(new Object[0]);
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateInputOutputParameter(ObjectNode context, IValidationContext ctx) {
        Behavior selection = context.getSelection();
        if (selection != null) {
            Parameter inParam = null;
            Parameter outParam = null;
            for (Parameter param : selection.getOwnedParameters()) {
                switch (param.getDirection()) {
                    case IN_LITERAL: {
                        if (inParam != null) {
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        inParam = param;
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        if (outParam != null) {
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        outParam = param;
                        break;
                    }
                    case INOUT_LITERAL: {
                        if (inParam != null) {
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        inParam = param;
                        if (outParam != null) {
                            return ctx.createFailureStatus(new Object[0]);
                        }
                        outParam = param;
                    }
                }
            }
            if (inParam == null || outParam == null) {
                return ctx.createFailureStatus(new Object[0]);
            }
            if (!UMLValidationHelper.isSuperType(inParam.getType(), context.getType())) {
                return ctx.createFailureStatus(new Object[0]);
            }
            if (!UMLValidationHelper.isSuperType(context.getType(), outParam.getType())) {
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    private static boolean isSuperType(Type superType, Type childType) {
        if (superType == null || childType == null) {
            return true;
        }
        return childType.conformsTo(superType);
    }

    private static List<ObjectNode> getDownStreamObjectNodes(ObjectFlow objectFlow) {
        ActivityNode target = objectFlow.getTarget();
        if (target instanceof ObjectNode) {
            return Collections.singletonList((ObjectNode)target);
        }
        if (target instanceof ControlNode) {
            LinkedList<ObjectNode> result = new LinkedList<ObjectNode>();
            for (ActivityEdge outgoingEdge : target.getOutgoings()) {
                if (!(outgoingEdge instanceof ObjectFlow) || outgoingEdge.equals(objectFlow)) continue;
                result.addAll(UMLValidationHelper.getDownStreamObjectNodes((ObjectFlow)outgoingEdge));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<Type> getUpstreamExpectedTypes(ObjectFlow objectFlow, List<ObjectFlow> alreadyMetObjectFlows) {
        ActivityNode src = objectFlow.getSource();
        if (alreadyMetObjectFlows.contains(objectFlow)) {
            return Collections.emptyList();
        }
        alreadyMetObjectFlows.add(objectFlow);
        if (src instanceof ObjectNode) {
            Type type = ((ObjectNode)src).getType();
            if (type != null) {
                return Collections.singletonList(type);
            }
            return Collections.emptyList();
        }
        if (src instanceof ControlNode) {
            LinkedList<Type> result = new LinkedList<Type>();
            for (ActivityEdge incomingEdge : src.getIncomings()) {
                if (!(incomingEdge instanceof ObjectFlow)) continue;
                ObjectFlow incomingFlow = (ObjectFlow)incomingEdge;
                result.addAll(UMLValidationHelper.getTypeComingFromFlow(incomingFlow, alreadyMetObjectFlows));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<Type> getDownstreamExpectedTypes(ObjectFlow objectFlow, List<ObjectFlow> alreadyMetObjectFlows) {
        ActivityNode target = objectFlow.getTarget();
        if (alreadyMetObjectFlows.contains(objectFlow)) {
            return Collections.emptyList();
        }
        alreadyMetObjectFlows.add(objectFlow);
        if (target instanceof ObjectNode) {
            Type type = ((ObjectNode)target).getType();
            if (type != null) {
                return Collections.singletonList(type);
            }
            return Collections.emptyList();
        }
        if (target instanceof ControlNode) {
            LinkedList<Type> result = new LinkedList<Type>();
            for (ActivityEdge outgoingEdge : target.getOutgoings()) {
                if (!(outgoingEdge instanceof ObjectFlow)) continue;
                ObjectFlow outgoingFlow = (ObjectFlow)outgoingEdge;
                result.addAll(UMLValidationHelper.getTypeExpectedByFlow(outgoingFlow, alreadyMetObjectFlows));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<Type> getTypeComingFromFlow(ObjectFlow inputFlow, List<ObjectFlow> alreadyMetObjectFlows) {
        LinkedList<Type> result;
        block11: {
            block12: {
                block10: {
                    result = new LinkedList<Type>();
                    if (inputFlow.getTransformation() != null || inputFlow.getSelection() != null) break block10;
                    result.addAll(UMLValidationHelper.getUpstreamExpectedTypes(inputFlow, alreadyMetObjectFlows));
                    break block11;
                }
                if (inputFlow.getTransformation() == null) break block12;
                for (Parameter transfParam : inputFlow.getTransformation().getOwnedParameters()) {
                    switch (transfParam.getDirection()) {
                        case IN_LITERAL: {
                            break;
                        }
                        case INOUT_LITERAL: 
                        case OUT_LITERAL: 
                        case RETURN_LITERAL: {
                            if (transfParam.getType() == null) break;
                            result.add(transfParam.getType());
                        }
                    }
                }
                break block11;
            }
            if (inputFlow.getSelection() == null) break block11;
            for (Parameter selParam : inputFlow.getSelection().getOwnedParameters()) {
                switch (selParam.getDirection()) {
                    case IN_LITERAL: {
                        break;
                    }
                    case INOUT_LITERAL: 
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        if (selParam.getType() == null) break;
                        result.add(selParam.getType());
                    }
                }
            }
        }
        return result;
    }

    private static List<Type> getTypeExpectedByFlow(ObjectFlow outputFlow, List<ObjectFlow> alreadyMetObjectFlows) {
        LinkedList<Type> result = new LinkedList<Type>();
        if (outputFlow.getTransformation() == null) {
            result.addAll(UMLValidationHelper.getDownstreamExpectedTypes(outputFlow, alreadyMetObjectFlows));
        } else {
            for (Parameter transfParam : outputFlow.getTransformation().getOwnedParameters()) {
                switch (transfParam.getDirection()) {
                    case IN_LITERAL: 
                    case INOUT_LITERAL: {
                        if (transfParam.getType() == null) break;
                        result.add(transfParam.getType());
                        break;
                    }
                }
            }
        }
        return result;
    }

    @PinAndParameterSynchronizeValidator
    public static IStatus validateCallOperation(CallOperationAction action, IValidationContext ctx) {
        if (action.getOperation() == null) {
            return ctx.createFailureStatus(new Object[]{String.format("%s does not have operation", action.getName())});
        }
        List<Parameter> ins = UMLValidationHelper.getParameters(action.getOperation(), Direction.IN);
        EList inputs = action.getArguments();
        if (ins.size() != inputs.size()) {
            return ctx.createFailureStatus(new Object[]{String.format("pins of %s does not have the same number of input pins as input parameters of the operation %s", action.getName(), action.getOperation().getName())});
        }
        int index = 0;
        for (Parameter p : ins) {
            IStatus status = UMLValidationHelper.validatePin(index, p, (EList<? extends Pin>)inputs, ctx);
            if (!status.isOK()) {
                return status;
            }
            ++index;
        }
        List<Parameter> outs = UMLValidationHelper.getParameters(action.getOperation(), Direction.OUT);
        int indexOuts = 0;
        EList outputs = action.getOutputs();
        if (outs.size() != outputs.size()) {
            return ctx.createFailureStatus(new Object[]{String.format("pins of %s does not have the same number of output pins as output parameters of the operation %s", action.getName(), action.getOperation().getName())});
        }
        for (Parameter p : outs) {
            IStatus status = UMLValidationHelper.validatePin(indexOuts, p, (EList<? extends Pin>)outputs, ctx);
            if (!status.isOK()) {
                return status;
            }
            ++indexOuts;
        }
        return Status.OK_STATUS;
    }

    private static IStatus validatePin(int index, Parameter p, EList<? extends Pin> inputs, IValidationContext ctx) {
        Pin pin = (Pin)inputs.get(index);
        for (EStructuralFeature a : pin.eClass().getEAllStructuralFeatures()) {
            EStructuralFeature feature = UMLValidationHelper.getFeature(a.getName(), p.eClass());
            if (a.isDerived() || !a.isChangeable() || feature == null || pin.eGet(a).equals(p.eGet(feature))) continue;
            return ctx.createFailureStatus(new Object[]{String.format("attribute %s and attribute %s are different for pin %s", a.getName(), feature.getName(), pin.getName())});
        }
        if ((pin.getType() == null || p.getType() == null) && p.getType() != pin.getType()) {
            return ctx.createFailureStatus(new Object[]{String.format("type of pin %s is different the parameter %s", pin.getName(), p.getName())});
        }
        if (pin.getType() != null && !pin.getType().conformsTo(p.getType())) {
            return ctx.createFailureStatus(new Object[]{String.format("type of pin %s is not compatible with the parameter %s", pin.getName(), p.getName())});
        }
        return Status.OK_STATUS;
    }

    private static EStructuralFeature getFeature(String name, EClass eclass) {
        for (EStructuralFeature a : eclass.getEAllAttributes()) {
            if (a.getName() == null || !a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    private static List<Parameter> getParameters(Operation operation, Direction theDirection) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(operation.getOwnedParameters().size());
        for (Parameter p : operation.getOwnedParameters()) {
            if (theDirection == Direction.IN) {
                if (p.getDirection() != ParameterDirectionKind.IN_LITERAL && p.getDirection() != ParameterDirectionKind.INOUT_LITERAL) continue;
                parameters.add(p);
                continue;
            }
            if (theDirection != Direction.OUT || p.getDirection() != ParameterDirectionKind.OUT_LITERAL && p.getDirection() != ParameterDirectionKind.INOUT_LITERAL && p.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            parameters.add(p);
        }
        return parameters;
    }

    static enum Direction {
        IN,
        OUT;

    }
}

