/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class RowReorderCommand
implements ILayerCommand {
    private RowPositionCoordinate fromRowPositionCoordinate;
    private RowPositionCoordinate toRowPositionCoordinate;
    private boolean reorderToTopEdge;

    public RowReorderCommand(ILayer layer, int fromRowPosition, int toRowPosition) {
        this.fromRowPositionCoordinate = new RowPositionCoordinate(layer, fromRowPosition);
        if (toRowPosition < layer.getRowCount()) {
            this.reorderToTopEdge = true;
        } else {
            this.reorderToTopEdge = false;
            --toRowPosition;
        }
        this.toRowPositionCoordinate = new RowPositionCoordinate(layer, toRowPosition);
    }

    protected RowReorderCommand(RowReorderCommand command) {
        this.fromRowPositionCoordinate = command.fromRowPositionCoordinate;
        this.toRowPositionCoordinate = command.toRowPositionCoordinate;
        this.reorderToTopEdge = command.reorderToTopEdge;
    }

    public int getFromRowPosition() {
        return this.fromRowPositionCoordinate.getRowPosition();
    }

    public int getToRowPosition() {
        return this.toRowPositionCoordinate.getRowPosition();
    }

    public boolean isReorderToTopEdge() {
        return this.reorderToTopEdge;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        RowPositionCoordinate targetFromRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.fromRowPositionCoordinate, targetLayer);
        RowPositionCoordinate targetToRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.toRowPositionCoordinate, targetLayer);
        if (targetFromRowPositionCoordinate != null && targetToRowPositionCoordinate != null) {
            this.fromRowPositionCoordinate = targetFromRowPositionCoordinate;
            this.toRowPositionCoordinate = targetToRowPositionCoordinate;
            return true;
        }
        return false;
    }

    @Override
    public RowReorderCommand cloneCommand() {
        return new RowReorderCommand(this);
    }
}

