/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.dialogs;

import com.swtdesigner.ResourceManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.pages.PapyrusSearchResultPage;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.papyrus.views.search.utils.MatchUtils;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class ReplaceDialog
extends Dialog {
    PapyrusSearchResultPage fResultPage;
    AbstractPapyrusQuery fQuery;
    Object[] fSelection;
    Text replaceText;

    public ReplaceDialog(Shell parentShell, PapyrusSearchResultPage fResultPage, Object[] selection) {
        super(parentShell);
        this.fResultPage = fResultPage;
        this.fSelection = selection;
        this.fQuery = (AbstractPapyrusQuery)fResultPage.getInput().getQuery();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ReplaceDialog_0);
        shell.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.uml.search.ui", "icons/PapyrusSearch.png"));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label labelQueryText = new Label(composite, 0);
        labelQueryText.setText(Messages.ReplaceDialog_1);
        Text queyText = new Text(composite, 2048);
        queyText.setEnabled(false);
        queyText.setText(this.fQuery.getSearchQueryText());
        queyText.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        Label labelReplace = new Label(composite, 0);
        labelReplace.setText(Messages.ReplaceDialog_2);
        this.replaceText = new Text(composite, 2048);
        this.replaceText.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        Label warningLabel = new Label(composite, 0);
        warningLabel.setText(Messages.ReplaceDialog_3);
        warningLabel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 0));
        return parent;
    }

    private String computeReplacementString(Pattern pattern, String originalText, String replacementText) throws PatternSyntaxException {
        if (pattern != null) {
            StringBuffer sb;
            Matcher matcher;
            try {
                matcher = pattern.matcher(originalText);
                sb = new StringBuffer();
                matcher.reset();
                if (!matcher.find()) {
                    return null;
                }
                matcher.appendReplacement(sb, replacementText);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PatternSyntaxException(ex.getLocalizedMessage(), replacementText, -1);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return replacementText;
    }

    private void change(AttributeMatch match) {
        if (match.getSource() instanceof EObject) {
            Object value;
            Object tagValue;
            Property source;
            Class containingClass;
            EObject target = (EObject)match.getSource();
            if (match.getMetaAttribute() instanceof EAttribute) {
                Object value2 = target.eGet((EStructuralFeature)((EAttribute)match.getMetaAttribute()));
                if (value2 != null && value2 instanceof String) {
                    String originalvalue = (String)value2;
                    Pattern pattern = PatternHelper.getInstance().createPattern(this.fQuery.getSearchQueryText(), this.fQuery.isCaseSensitive(), this.fQuery.isRegularExpression());
                    String newValue = this.computeReplacementString(pattern, originalvalue, this.replaceText.getText());
                    target.eSet((EStructuralFeature)((EAttribute)match.getMetaAttribute()), (Object)newValue);
                }
            } else if (match.getMetaAttribute() instanceof Property && (containingClass = (source = (Property)match.getMetaAttribute()).getClass_()) instanceof Stereotype && target instanceof Element && (tagValue = ((Element)target).getValue((Stereotype)containingClass, source.getName())) instanceof String && (value = tagValue) != null && value instanceof String) {
                String originalvalue = (String)value;
                Pattern pattern = PatternHelper.getInstance().createPattern(this.fQuery.getSearchQueryText(), this.fQuery.isCaseSensitive(), this.fQuery.isRegularExpression());
                String newValue = this.computeReplacementString(pattern, originalvalue, this.replaceText.getText());
                ((Element)target).setValue((Stereotype)containingClass, source.getName(), (Object)newValue);
            }
        }
    }

    protected void okPressed() {
        HashSet<AbstractResultEntry> toProcess = new HashSet<AbstractResultEntry>();
        HashSet<ScopeEntry> toSave = new HashSet<ScopeEntry>();
        if (this.fSelection == null) {
            toProcess.addAll(MatchUtils.getMatches((AbstractTextSearchResult)this.fResultPage.getInput(), (boolean)false));
        } else {
            for (Object selected : Arrays.asList(this.fSelection)) {
                if (!(selected instanceof AbstractResultEntry)) continue;
                toProcess.add((AbstractResultEntry)selected);
            }
        }
        for (AbstractResultEntry match : toProcess) {
            if (!(match instanceof AttributeMatch)) continue;
            final AttributeMatch attributeMatch = (AttributeMatch)match;
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)attributeMatch.getSource());
            Object element = match.getElement();
            if (editingDomain != null) {
                if (!(editingDomain instanceof TransactionalEditingDomain)) continue;
                editingDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)editingDomain){

                    protected void doExecute() {
                        ReplaceDialog.this.change(attributeMatch);
                    }
                });
                continue;
            }
            if (!(element instanceof ScopeEntry)) continue;
            this.change(attributeMatch);
            toSave.add((ScopeEntry)element);
        }
        for (ScopeEntry scopeEntry : toSave) {
            try {
                scopeEntry.getModelSet().save((IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                Activator.log.error(String.valueOf(Messages.ReplaceDialog_4) + scopeEntry.getModelSet(), (Throwable)e);
            }
        }
        super.okPressed();
    }
}

