/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.factory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.toolsmiths.factory.FileBasedExtensionFactory;
import org.eclipse.papyrus.toolsmiths.messages.Messages;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizationPluginPackage;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.FileBasedCustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.TableConfiguration;
import org.w3c.dom.Element;

public class TableExtensionFactory
extends FileBasedExtensionFactory {
    public static final String TABLE_ROOT_FOLDER = new String("table");

    public TableExtensionFactory() {
        super(Messages.TableFactory_Table, "org.eclipse.papyrus.infra.nattable.configuration", "file", "configuration", true);
    }

    public void addElement(CustomizableElement element, IPluginEditor editor) {
        super.addElement(element, editor);
        editor.addDependency("org.eclipse.papyrus.infra.nattable");
    }

    protected Element createExtension(FileBasedCustomizableElement customizableElement, IPluginEditor editor) {
        TableConfiguration element;
        Element extension = super.createExtension(customizableElement, editor);
        if (customizableElement instanceof TableConfiguration && (element = (TableConfiguration)customizableElement).getType() != null) {
            extension.setAttribute("type", element.getType());
        }
        return extension;
    }

    protected String getTargetPath(FileBasedCustomizableElement element) {
        return this.getFilePath(element.getFile());
    }

    protected String getFilePath(String file) {
        return String.valueOf(File.separator) + TABLE_ROOT_FOLDER + File.separator + this.getFileName(file);
    }

    public EClass getCustomizableElementClass() {
        return CustomizationPluginPackage.eINSTANCE.getTableConfiguration();
    }

    protected void copyFile(FileBasedCustomizableElement element, IPluginEditor editor) throws FileNotFoundException, IOException {
        this.copyFile(element.getFile(), this.getFilePath(((TableConfiguration)element).getFile()), editor);
    }
}

