/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.editor;

import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.SashWindowsContainer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;

public class SashTabDecorationSynchronizer {
    private SashWindowsContainer container;
    IPageLifeCycleEventsListener pageLifeCycleListener = new IPageLifeCycleEventsListener(){

        @Override
        public void pageChanged(IPage newPage) {
        }

        @Override
        public void pageOpened(IPage page) {
            SashTabDecorationSynchronizer.this.attachPage(page);
        }

        @Override
        public void pageDeactivated(IPage page) {
        }

        @Override
        public void pageClosed(IPage page) {
            SashTabDecorationSynchronizer.this.detachPage(page);
        }

        @Override
        public void pageActivated(IPage page) {
        }

        @Override
        public void pageAboutToBeOpened(IPage page) {
        }

        @Override
        public void pageAboutToBeClosed(IPage page) {
        }
    };
    private IPropertyListener editorPartPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1 && source instanceof IEditorPart) {
                SashTabDecorationSynchronizer.this.refreshContainerTabForPage((IEditorPart)source);
            }
        }
    };

    public SashTabDecorationSynchronizer(SashWindowsContainer container) {
        this.container = container;
        this.attachContainerPages();
        this.attachListeners();
    }

    public void dispose() {
        this.detachListeners();
        this.detachContainerPages();
    }

    protected void attachListeners() {
        this.container.addPageLifeCycleListener(this.pageLifeCycleListener);
    }

    protected void detachListeners() {
        if (!this.container.isDisposed()) {
            this.container.removePageLifeCycleListener(this.pageLifeCycleListener);
        }
    }

    protected void attachPage(IPage page) {
        if (page instanceof IEditorPage) {
            Activator.log.debug("attachPage( " + page + " )");
            IEditorPage editorPage = (IEditorPage)page;
            editorPage.getIEditorPart().addPropertyListener(this.editorPartPropertyListener);
        }
    }

    protected void detachPage(IPage page) {
    }

    protected void refreshContainerTabForPage(IEditorPart source) {
        IPage page = this.container.lookupIPageByIEditorPart(source);
        this.refreshContainerTabForPage(page);
    }

    protected void refreshContainerTabForPage(IPage page) {
        this.container.refreshPageTab(page);
    }

    private void detachContainerPages() {
        if (!this.container.isDisposed()) {
            this.container.visit(new DetachVisitor());
        }
    }

    private void attachContainerPages() {
        this.container.visit(new AttachVisitor());
    }

    private class AttachVisitor
    implements IPageVisitor {
        private AttachVisitor() {
        }

        @Override
        public void accept(IComponentPage page) {
        }

        @Override
        public void accept(IEditorPage page) {
            SashTabDecorationSynchronizer.this.attachPage(page);
        }
    }

    private class DetachVisitor
    implements IPageVisitor {
        private DetachVisitor() {
        }

        @Override
        public void accept(IComponentPage page) {
        }

        @Override
        public void accept(IEditorPage page) {
            SashTabDecorationSynchronizer.this.detachPage(page);
        }
    }
}

