/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public abstract class ResourceAdapter
extends AdapterImpl {
    public void setTarget(Notifier newTarget) {
        if (newTarget instanceof ResourceSet) {
            super.setTarget(newTarget);
            for (Resource next : ImmutableList.copyOf((Collection)((ResourceSet)newTarget).getResources())) {
                this.addAdapter((Notifier)next);
                this.handleResourceAdded(next);
                if (!next.isLoaded()) continue;
                this.handleResourceLoaded(next);
            }
        }
    }

    protected ResourceSet getResourceSet() {
        return (ResourceSet)this.getTarget();
    }

    public void notifyChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        if (!msg.isTouch()) {
            if (notifier instanceof ResourceSet) {
                if (msg.getFeatureID(ResourceSet.class) == 0) {
                    this.handleResourceSetResources(msg);
                }
            } else if (notifier instanceof Resource) {
                switch (msg.getFeatureID(Resource.class)) {
                    case 4: {
                        switch (msg.getEventType()) {
                            case 1: 
                            case 2: {
                                if (msg.getNewBooleanValue()) {
                                    this.handleResourceLoaded0((Resource)notifier);
                                    break;
                                }
                                this.handleResourceUnloaded0((Resource)notifier);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (msg.getEventType()) {
                            case 1: 
                            case 2: {
                                this.handleResourceURI((Resource)notifier, (URI)msg.getOldValue(), (URI)msg.getNewValue());
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.handleResourceContents(msg);
                    }
                }
            }
        }
    }

    protected void addAdapter(Notifier notifier) {
        EList adapters = notifier.eAdapters();
        if (!adapters.contains((Object)this)) {
            adapters.add((Object)this);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    protected void handleResourceSetResources(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                Resource resource = (Resource)msg.getNewValue();
                this.addAdapter((Notifier)resource);
                this.handleResourceAdded(resource);
                break;
            }
            case 5: {
                for (Object next : (Iterable)msg.getNewValue()) {
                    Resource resource = (Resource)next;
                    this.addAdapter((Notifier)resource);
                    this.handleResourceAdded(resource);
                }
                break;
            }
            case 4: {
                Resource resource = (Resource)msg.getOldValue();
                try {
                    this.handleResourceRemoved(resource);
                    break;
                }
                finally {
                    this.removeAdapter((Notifier)resource);
                }
            }
            case 6: {
                for (Object next : (Iterable)msg.getOldValue()) {
                    Resource resource = (Resource)next;
                    try {
                        this.handleResourceRemoved(resource);
                    }
                    finally {
                        this.removeAdapter((Notifier)resource);
                    }
                }
                break;
            }
            case 1: {
                Resource oldResource = (Resource)msg.getOldValue();
                try {
                    this.handleResourceRemoved(oldResource);
                }
                finally {
                    this.removeAdapter((Notifier)oldResource);
                }
                Resource newResource = (Resource)msg.getOldValue();
                this.addAdapter((Notifier)newResource);
                this.handleResourceAdded(newResource);
            }
        }
    }

    protected void handleResourceContents(Notification msg) {
        Resource.Internal resource = (Resource.Internal)msg.getNotifier();
        if (resource.isLoaded() && !this.isLoading(resource)) {
            switch (msg.getEventType()) {
                case 3: {
                    Object newValue = msg.getNewValue();
                    if (!(newValue instanceof EObject)) break;
                    this.handleRootAdded((Resource)resource, (EObject)newValue);
                    break;
                }
                case 5: {
                    Object newValue = msg.getNewValue();
                    if (!(newValue instanceof Iterable)) break;
                    for (Object next : (Iterable)newValue) {
                        this.handleRootAdded((Resource)resource, (EObject)next);
                    }
                    break;
                }
                case 4: {
                    Object oldValue = msg.getOldValue();
                    if (!(oldValue instanceof EObject)) break;
                    this.handleRootRemoved((Resource)resource, (EObject)oldValue);
                    break;
                }
                case 6: {
                    Object oldValue = msg.getOldValue();
                    if (!(oldValue instanceof Iterable)) break;
                    for (Object next : (Iterable)oldValue) {
                        this.handleRootRemoved((Resource)resource, (EObject)next);
                    }
                    break;
                }
                case 1: {
                    Object oldValue = msg.getOldValue();
                    Object newValue = msg.getNewValue();
                    if (!(oldValue instanceof EObject) || !(newValue instanceof EObject)) break;
                    this.handleRootRemoved((Resource)resource, (EObject)oldValue);
                    this.handleRootAdded((Resource)resource, (EObject)newValue);
                }
            }
        }
    }

    protected void handleResourceAdded(Resource resource) {
    }

    protected void handleResourceRemoved(Resource resource) {
    }

    void handleResourceLoaded0(Resource resource) {
        this.handleResourceLoaded(resource);
    }

    boolean isLoading(Resource.Internal resource) {
        return resource.isLoading();
    }

    protected void handleResourceLoaded(Resource resource) {
    }

    void handleResourceUnloaded0(Resource resource) {
        this.handleResourceUnloaded(resource);
    }

    protected void handleResourceUnloaded(Resource resource) {
    }

    protected void handleResourceURI(Resource resource, URI oldURI, URI newURI) {
    }

    protected void handleRootAdded(Resource resource, EObject root) {
    }

    protected void handleRootRemoved(Resource resource, EObject root) {
    }

    public static class Transactional
    extends ResourceAdapter
    implements ResourceSetListener {
        private final boolean isPrecommit;
        private final NotificationFilter filter = NotificationFilter.NOT_TOUCH.and(this.createFilter());
        private List<Notification> notifications;
        private Map<Resource, Boolean> loadingState;

        public Transactional() {
            this(false);
        }

        public Transactional(boolean isPrecommit) {
            this.isPrecommit = isPrecommit;
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }

        public boolean isPrecommitOnly() {
            return this.isPrecommit;
        }

        public boolean isPostcommitOnly() {
            return !this.isPrecommit;
        }

        protected NotificationFilter createFilter() {
            return NotificationFilter.createNotifierTypeFilter(ResourceSet.class).or(NotificationFilter.createNotifierTypeFilter(Resource.class));
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            this.handleResourceSetChangeEvent0(event);
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            this.handleResourceSetChangeEvent0(event);
            return null;
        }

        public void install(TransactionalEditingDomain editingDomain) {
            editingDomain.addResourceSetListener((ResourceSetListener)this);
            for (Resource next : ImmutableList.copyOf((Collection)editingDomain.getResourceSet().getResources())) {
                this.handleResourceAdded(next);
                if (!next.isLoaded()) continue;
                this.handleResourceLoaded(next);
            }
        }

        public void uninstall(TransactionalEditingDomain editingDomain) {
            try {
                ResourceSet resourceSet = editingDomain.getResourceSet();
                if (resourceSet != null) {
                    for (Resource next : ImmutableList.copyOf((Collection)resourceSet.getResources())) {
                        this.handleResourceRemoved(next);
                    }
                }
            }
            finally {
                editingDomain.removeResourceSetListener((ResourceSetListener)this);
            }
        }

        protected void handleResourceSetChangeEvent0(ResourceSetChangeEvent event) {
            try {
                this.notifications = event.getNotifications();
                this.handleResourceSetChangeEvent(event);
            }
            finally {
                this.notifications = null;
                this.loadingState = null;
            }
        }

        protected void handleResourceSetChangeEvent(ResourceSetChangeEvent event) {
            for (Notification next : event.getNotifications()) {
                this.notifyChanged(next);
            }
        }

        @Override
        public final void setTarget(Notifier newTarget) {
        }

        public final void unsetTarget(Notifier oldTarget) {
        }

        @Override
        protected final void addAdapter(Notifier notifier) {
        }

        @Override
        protected final void removeAdapter(Notifier notifier) {
        }

        @Override
        boolean isLoading(Resource.Internal resource) {
            return this.getLoadingState().computeIfAbsent((Resource)resource, r -> this.notifications.stream().anyMatch(this.isLoadOf((Resource)r)));
        }

        private Predicate<Notification> isLoadOf(Resource resource) {
            return msg -> msg.getNotifier() == resource && msg.getFeatureID(Resource.class) == 4 && msg.getNewBooleanValue();
        }

        Map<Resource, Boolean> getLoadingState() {
            if (this.loadingState == null) {
                this.loadingState = new HashMap<Resource, Boolean>();
            }
            return this.loadingState;
        }

        void setLoading(Resource resource, boolean loading) {
            this.getLoadingState().put(resource, loading);
        }

        @Override
        void handleResourceLoaded0(Resource resource) {
            this.setLoading(resource, true);
            super.handleResourceLoaded0(resource);
        }

        @Override
        void handleResourceUnloaded0(Resource resource) {
            this.setLoading(resource, false);
            super.handleResourceUnloaded0(resource);
        }
    }
}

