/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.GMFObservableList;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.GMFObservableValue;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFEnumeratorContentProvider;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.BooleanCombo;
import org.eclipse.papyrus.infra.widgets.editors.DoubleEditor;
import org.eclipse.papyrus.infra.widgets.editors.EnumCombo;
import org.eclipse.papyrus.infra.widgets.editors.FloatEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.IntegerEditor;
import org.eclipse.papyrus.infra.widgets.editors.LongEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleBooleanEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleDoubleEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleIntegerEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleStringEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TypedMultipleStringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.widgets.EObjectContentsEditor;
import org.eclipse.papyrus.uml.tools.utils.DataTypeUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public class EStructuralFeatureEditor
implements IValueChangeListener<Object>,
IListChangeListener<Object> {
    protected PageBook pageBook;
    protected Composite currentPage;
    protected int style = 0;
    protected IStaticContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected ReferenceValueFactory valueFactory;
    protected IChangeListener changeListener;
    private static final Map<String, Class<?>> TYPE_ALIASES = new HashMap();
    private static final Map<Class<?>, Class<? extends MultipleStringEditor<?>>> TYPE_TO_MULTI_EDITOR_CLASS;
    private static final Map<Class<?>, Class<? extends AbstractValueEditor>> TYPE_TO_SINGLE_EDITOR_CLASS;

    static {
        TYPE_ALIASES.put(String.class.getCanonicalName(), String.class);
        TYPE_ALIASES.put("string", String.class);
        TYPE_ALIASES.put(Boolean.class.getCanonicalName(), Boolean.class);
        TYPE_ALIASES.put("boolean", Boolean.class);
        TYPE_ALIASES.put("bool", Boolean.class);
        TYPE_ALIASES.put(Integer.class.getCanonicalName(), Integer.class);
        TYPE_ALIASES.put("int", Integer.class);
        TYPE_ALIASES.put("integer", Integer.class);
        TYPE_ALIASES.put(Long.class.getCanonicalName(), Long.class);
        TYPE_ALIASES.put("long", Long.class);
        TYPE_ALIASES.put(Float.class.getCanonicalName(), Float.class);
        TYPE_ALIASES.put("float", Float.class);
        TYPE_ALIASES.put(Double.class.getCanonicalName(), Double.class);
        TYPE_ALIASES.put("double", Double.class);
        TYPE_TO_MULTI_EDITOR_CLASS = new HashMap();
        TYPE_TO_SINGLE_EDITOR_CLASS = new HashMap();
        TYPE_TO_SINGLE_EDITOR_CLASS.put(String.class, StringEditor.class);
        TYPE_TO_MULTI_EDITOR_CLASS.put(String.class, TypedMultipleStringEditor.class);
        TYPE_TO_SINGLE_EDITOR_CLASS.put(Boolean.class, BooleanCombo.class);
        TYPE_TO_MULTI_EDITOR_CLASS.put(Boolean.class, MultipleBooleanEditor.class);
        TYPE_TO_SINGLE_EDITOR_CLASS.put(Integer.class, IntegerEditor.class);
        TYPE_TO_MULTI_EDITOR_CLASS.put(Integer.class, MultipleIntegerEditor.class);
        TYPE_TO_SINGLE_EDITOR_CLASS.put(Long.class, LongEditor.class);
        TYPE_TO_MULTI_EDITOR_CLASS.put(Long.class, MultipleIntegerEditor.class);
        TYPE_TO_SINGLE_EDITOR_CLASS.put(Float.class, FloatEditor.class);
        TYPE_TO_MULTI_EDITOR_CLASS.put(Float.class, MultipleDoubleEditor.class);
        TYPE_TO_SINGLE_EDITOR_CLASS.put(Double.class, DoubleEditor.class);
        TYPE_TO_MULTI_EDITOR_CLASS.put(Double.class, MultipleDoubleEditor.class);
    }

    public EStructuralFeatureEditor(Composite parent, int style) {
        this.style = style;
        this.pageBook = new PageBook(parent, style);
        this.currentPage = this.createEmptyPage();
        this.pageBook.showPage((Control)this.currentPage);
    }

    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
    }

    public void setValueFactory(ReferenceValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public void setChangeListener(IChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    protected Composite createEmptyPage() {
        return new Composite((Composite)this.pageBook, this.style);
    }

    public void setFeatureToEdit(String title, EStructuralFeature feature, EObject element) {
        Object editor;
        EClassifier featureType;
        Composite previousPage = this.currentPage;
        if (this.currentPage != null) {
            this.currentPage = null;
        }
        if (feature instanceof EReference) {
            if (feature.isMany()) {
                MultipleReferenceEditor editor2 = new MultipleReferenceEditor((Composite)this.pageBook, this.style);
                this.setMultipleValueEditorProperties((MultipleValueEditor<?>)editor2, (List)element.eGet(feature), element, title, feature);
                editor2.setProviders(this.contentProvider, this.labelProvider);
                editor2.setFactory(this.valueFactory);
                this.currentPage = editor2;
            } else {
                featureType = feature.getEType();
                if (featureType instanceof EClass && DataTypeUtil.isDataTypeDefinition((EClass)((EClass)featureType), (EObject)element)) {
                    editor = new EObjectContentsEditor((Composite)this.pageBook, this.style, (EReference)feature);
                    ((EObjectContentsEditor)((Object)editor)).setValue((IObservableValue)new GMFObservableValue(element, feature, EMFHelper.resolveEditingDomain((EObject)element)));
                    this.currentPage = editor;
                } else {
                    editor = new ReferenceDialog((Composite)this.pageBook, this.style);
                    this.setValueEditorProperties((AbstractValueEditor)editor, element, title, feature);
                    editor.setContentProvider(this.contentProvider);
                    editor.setLabelProvider(this.labelProvider);
                    editor.setValueFactory(this.valueFactory);
                    editor.setDirectCreation(((EReference)feature).isContainment());
                    this.currentPage = editor;
                }
            }
        }
        if (feature instanceof EAttribute) {
            featureType = feature.getEType();
            if (featureType instanceof EEnum) {
                if (feature.isMany()) {
                    editor = new MultipleReferenceEditor((Composite)this.pageBook, this.style);
                    this.setMultipleValueEditorProperties((MultipleValueEditor<?>)editor, (List)element.eGet(feature), element, title, feature);
                    editor.setProviders(this.contentProvider, this.labelProvider);
                    editor.setFactory(this.valueFactory);
                    this.currentPage = editor;
                } else {
                    editor = new EnumCombo((Composite)this.pageBook, this.style);
                    this.setValueEditorProperties((AbstractValueEditor)editor, element, title, feature);
                    editor.setContentProvider((IStaticContentProvider)new EMFEnumeratorContentProvider(feature));
                    this.currentPage = editor;
                }
            } else if (featureType instanceof EDataType) {
                String aliasedInstanceClassName = ((EDataType)featureType).getInstanceClassName();
                Class<?> clazz = TYPE_ALIASES.get(aliasedInstanceClassName);
                if (clazz == null) {
                    throw new IllegalArgumentException("No clazz has been found for aliasedInstanceClassName '" + aliasedInstanceClassName + "'");
                }
                if (feature.isMany()) {
                    this.createMultipleEditor(clazz, element, title, feature);
                } else {
                    this.createSingleEditor(clazz, element, title, feature);
                }
            }
        }
        if (this.currentPage == null) {
            this.currentPage = this.createEmptyPage();
        }
        this.pageBook.showPage((Control)this.currentPage);
        previousPage.dispose();
        previousPage = null;
    }

    protected void setValueEditorProperties(AbstractValueEditor editor, EObject stereotypeApplication, String title, EStructuralFeature feature) {
        GMFObservableValue observable = new GMFObservableValue(stereotypeApplication, feature, EMFHelper.resolveEditingDomain((EObject)stereotypeApplication));
        observable.addValueChangeListener((IValueChangeListener)this);
        editor.setLabel(title);
        editor.setReadOnly(!this.isEditable(stereotypeApplication, feature));
        editor.setModelObservable((IObservableValue)observable);
    }

    protected void setMultipleValueEditorProperties(MultipleValueEditor<?> editor, List<?> initialList, EObject stereotypeApplication, String title, EStructuralFeature feature) {
        GMFObservableList observable = new GMFObservableList(initialList, EMFHelper.resolveEditingDomain((EObject)stereotypeApplication), stereotypeApplication, feature);
        observable.addListChangeListener((IListChangeListener)this);
        editor.setLabel(title);
        editor.setUnique(feature.isUnique());
        editor.setOrdered(feature.isOrdered());
        editor.setUpperBound(feature.getUpperBound());
        editor.setModelObservable((IObservableList)observable);
        editor.setReadOnly(!this.isEditable(stereotypeApplication, feature));
        if (feature instanceof EReference) {
            editor.setDirectCreation(((EReference)feature).isContainment());
        }
        editor.addCommitListener((ICommitListener)observable);
    }

    private void createMultipleEditor(Class<?> typeClass, EObject element, String title, EStructuralFeature feature) {
        Class<MultipleStringEditor<?>> editorClazz = TYPE_TO_MULTI_EDITOR_CLASS.get(typeClass);
        if (editorClazz == null) {
            throw new IllegalArgumentException("No multiple editor has been found for class '" + typeClass + "'");
        }
        try {
            Constructor<MultipleStringEditor<?>> constructor = editorClazz.getConstructor(Composite.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
            MultipleStringEditor<?> editor = constructor.newInstance(this.pageBook, true, true, this.style);
            this.setMultipleValueEditorProperties((MultipleValueEditor<?>)editor, (List)element.eGet(feature), element, title, feature);
            this.currentPage = editor;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void createSingleEditor(Class<?> typeClass, EObject element, String title, EStructuralFeature feature) {
        Class<? extends AbstractValueEditor> clazz = TYPE_TO_SINGLE_EDITOR_CLASS.get(typeClass);
        if (clazz == null) {
            throw new IllegalArgumentException("No single editor has been found for class '" + typeClass + "'");
        }
        try {
            Constructor<? extends AbstractValueEditor> constructor = clazz.getConstructor(Composite.class, Integer.TYPE);
            AbstractValueEditor editor = constructor.newInstance(this.pageBook, this.style);
            this.setValueEditorProperties(editor, element, title, feature);
            this.currentPage = editor;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected boolean isEditable(EObject object, EStructuralFeature feature) {
        return !feature.isDerived() && feature.isChangeable() && !EMFHelper.isReadOnly((EObject)object);
    }

    public void setLayoutData(GridData data) {
        this.pageBook.setLayoutData((Object)data);
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        if (this.changeListener != null) {
            this.changeListener.handleChange(new ChangeEvent(event.getObservable()));
        }
    }

    public void handleListChange(ListChangeEvent<?> event) {
        if (this.changeListener != null) {
            this.changeListener.handleChange(new ChangeEvent(event.getObservable()));
        }
    }
}

