/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.GeneratorModule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.InputModel;
import org.eclipse.papyrus.uml.profile.types.generator.OutputModel;
import org.eclipse.uml2.common.util.UML2Util;

public abstract class AbstractGenerator<I extends EObject, O extends EObject> {
    private final Injector injector;
    @Inject
    @InputModel
    private EClass inputType;
    @Inject
    @OutputModel
    private EClass outputType;
    @Inject
    private Identifiers identifiers;

    public AbstractGenerator(Identifiers identifiers) {
        this(new GeneratorModule(identifiers));
    }

    public AbstractGenerator(GeneratorModule module) {
        this.injector = Guice.createInjector((Module[])new Module[]{module});
        this.injector.injectMembers((Object)this);
    }

    public String getLabel() {
        String result = this.identifiers.getLabel((EObject)this.outputType);
        return Strings.isNullOrEmpty((String)result) ? "output model" : result;
    }

    public IStatus generate(URI inputURI, URI outputURI) {
        IStatus result;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            EObject input = (EObject)UML2Util.load((ResourceSet)resourceSet, (URI)inputURI, (EClass)this.inputType);
            result = this.generate(input, outputURI);
        }
        finally {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
        return result;
    }

    public IStatus generate(I input, URI outputURI) {
        IStatus result;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            try {
                EObject set;
                Resource output = resourceSet.createResource(outputURI);
                result = this.generate(input, (EList<EObject>)output.getContents());
                EObject eObject = set = output.getContents().size() > 0 ? (EObject)output.getContents().get(0) : null;
                if (set instanceof ElementTypeSetConfiguration) {
                    ElementTypeSetConfiguration elementTypeSet = (ElementTypeSetConfiguration)set;
                    String elementTypeSetId = elementTypeSet.getIdentifier();
                    if (elementTypeSetId != null && elementTypeSetId.length() > 0) {
                        ((XMLResource)output).setID((EObject)elementTypeSet, this.escapeID(elementTypeSetId));
                    }
                    for (ElementTypeConfiguration elemTypeConfig : elementTypeSet.getElementTypeConfigurations()) {
                        String id = elemTypeConfig.getIdentifier();
                        if (id == null || id.length() <= 0) continue;
                        ((XMLResource)output).setID((EObject)elemTypeConfig, this.escapeID(id));
                    }
                }
                try {
                    output.save(null);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.profile.types.generator", "Failed to save output", (Throwable)e));
                }
                this.refreshContainer(outputURI);
            }
            catch (CoreException e) {
                result = e.getStatus();
                EMFHelper.unload((ResourceSet)resourceSet);
            }
        }
        finally {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
        return result;
    }

    public String escapeID(String id) {
        id = id.replaceAll(" ", "_");
        id = id.replaceAll(":", "_");
        return id;
    }

    public IStatus generate(I input, EList<? super EObject> output) {
        IStatus result = Status.OK_STATUS;
        output.add(this.generate(input));
        return result;
    }

    protected abstract O generate(I var1);

    protected void refreshContainer(URI resourceURI) throws CoreException {
        if (resourceURI.isPlatformResource()) {
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourceURI.toPlatformString(true))).getParent();
            if (container != null && container.isAccessible()) {
                container.refreshLocal(1, null);
            }
        } else if (resourceURI.isFile()) {
            try {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new java.net.URI(resourceURI.toString()));
                HashSet containers = Sets.newHashSet();
                IFile[] iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile next = iFileArray[n2];
                    containers.add(next.getParent());
                    ++n2;
                }
                for (IFile next : containers) {
                    next.refreshLocal(1, null);
                }
            }
            catch (URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.profile.types.generator", "Bad resource URI", (Throwable)e));
            }
        }
    }
}

