/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.editpolicies;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ProviderServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.css.editpolicies.EventListenerEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.CSSHelper;

public class EventListenerEditPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider {
    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation = (CreateEditPoliciesOperation)operation;
        EditPart editPart = epOperation.getEditPart();
        if (!ProviderServiceUtil.isEnabled((IEditPolicyProvider)this, (EditPart)editPart)) {
            return false;
        }
        if (!(editPart instanceof GraphicalEditPart)) {
            return false;
        }
        EditingDomain domain = EMFHelper.resolveEditingDomain((Object)editPart);
        if (domain == null) {
            return false;
        }
        ResourceSet resourceSet = domain.getResourceSet();
        return CSSHelper.isCSSSupported(resourceSet);
    }

    public void createEditPolicies(EditPart editPart) {
        editPart.installEditPolicy((Object)"EVENT_LISTENER", (EditPolicy)new EventListenerEditPolicy());
    }
}

