/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpart;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IControlParserForDirectEdit;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypePropertyDirectEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.EditingFlowPage;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.uml.diagram.common.parser.StereotypePropertyParser;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.profile.structure.AppliedStereotypeProperty;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AppliedStereotypeMultilinePropertyEditPart
extends CompartmentEditPart
implements ITextAwareEditPart,
NotificationListener,
IPapyrusListener,
IControlParserForDirectEdit {
    private static final String LISTENER_NAME_ROOT = "SemanticModel";
    private static final String PRIMARY_VIEW = "PrimaryView";
    private static final String ADD_PARENT_MODEL = "AddParentModel";
    public static final String ID = "AppliedStereotypeProperty";
    protected EObject stereotypeApplication;
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private String defaultText;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;

    public AppliedStereotypeMultilinePropertyEditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new UMLTextSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AppliedStereotypePropertyDirectEditPolicy());
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        return "";
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof FlowPage) {
            ((FlowPage)figure).removeAll();
            this.generateBlockForText(text, (FlowPage)figure);
        }
    }

    protected void generateBlockForText(String text, FlowPage page) {
        if (text != null && text.length() != 0) {
            TextFlowEx textFlow = new TextFlowEx(text);
            page.add((IFigure)textFlow);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        return null;
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        }
    }

    protected List<?> getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        return null;
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            EObject element = this.resolveSemanticElement();
            SemanticAdapter sAdapter = new SemanticAdapter(element, (Object)this.getNotationView());
            text = this.getParser().getPrintString((IAdaptable)sAdapter, this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = this.defaultText;
        }
        return text;
    }

    public void setLabelText(String text) {
        EditPolicy sfEditPolicy;
        this.setLabelTextHelper(this.getFigure(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new SemanticAdapter(this.resolveSemanticElement(), (Object)this.getNotationView()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        if (!((Property)this.resolveSemanticElement()).isDerived()) {
            return this.getParser() != null;
        }
        return false;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = AppliedStereotypeMultilinePropertyEditPart.this.getParserElement();
                    final IParser parser = AppliedStereotypeMultilinePropertyEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)AppliedStereotypeMultilinePropertyEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = new StereotypePropertyParser();
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), (CellEditorLocator)new MultilineCellEditorLocator((IMultilineEditableFigure)this.getFigure())));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AppliedStereotypeMultilinePropertyEditPart.this.getManager().show();
            }
        });
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof DirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction(this.getAdapter(AppliedStereotypeProperty.class));
                Dialog dialog = null;
                if (this.configuration instanceof ICustomDirectEditorConfiguration) {
                    this.setManager(((ICustomDirectEditorConfiguration)this.configuration).createDirectEditManager((ITextAwareEditPart)this));
                    this.initializeDirectEditManager(theRequest);
                    return;
                }
                if (this.configuration instanceof IPopupEditorConfiguration) {
                    IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                    if (helper != null) {
                        helper.showEditor();
                    }
                    return;
                }
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        AppliedStereotypeMultilinePropertyEditPart.this.configuration.postEditAction((Object)AppliedStereotypeMultilinePropertyEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        @Override
                        public void run() {
                            if (AppliedStereotypeMultilinePropertyEditPart.this.isActive() && AppliedStereotypeMultilinePropertyEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    AppliedStereotypeMultilinePropertyEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && AppliedStereotypeMultilinePropertyEditPart.this.getEditText().equals(AppliedStereotypeMultilinePropertyEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    AppliedStereotypeMultilinePropertyEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    AppliedStereotypeMultilinePropertyEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    protected void initializeDirectEditManager(final Request request) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (AppliedStereotypeMultilinePropertyEditPart.this.isActive() && AppliedStereotypeMultilinePropertyEditPart.this.isEditable()) {
                        if (request.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)request.getExtendedData().get("directedit_extendeddata_initial_char");
                            AppliedStereotypeMultilinePropertyEditPart.this.performDirectEdit(initialChar.charValue());
                        } else {
                            AppliedStereotypeMultilinePropertyEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getEditPolicy("MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter(LISTENER_NAME_ROOT + i, this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter(LISTENER_NAME_ROOT + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = AppliedStereotypeMultilinePropertyEditPart.this.getLabelTextHelper(AppliedStereotypeMultilinePropertyEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return (View)this.getModel();
    }

    public int getDirectEditionType() {
        if (this.checkExtendedEditor()) {
            this.initExtendedEditorConfiguration();
            return 4;
        }
        if (this.checkDefaultEdition()) {
            return 2;
        }
        return 8;
    }

    protected boolean checkExtendedEditor() {
        EObject resolveSemanticElement = this.resolveSemanticElement();
        if (resolveSemanticElement != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((EObject)resolveSemanticElement);
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getParser() != null;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + AppliedStereotypeProperty.class.getName());
            this.configuration = languagePreferred != null && !"".equals(languagePreferred) ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (EObject)this.resolveSemanticElement()) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (EObject)this.resolveSemanticElement());
        }
    }

    protected void updateExtendedEditorConfiguration() {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + AppliedStereotypeProperty.class.getName());
        if (languagePreferred != null && !"".equals(languagePreferred) && languagePreferred != this.configuration.getLanguage()) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (EObject)this.resolveSemanticElement());
        } else if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        }
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (AppliedStereotypeMultilinePropertyEditPart.this.isActive() && AppliedStereotypeMultilinePropertyEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            AppliedStereotypeMultilinePropertyEditPart.this.performDirectEdit(initialChar.charValue());
                        } else {
                            AppliedStereotypeMultilinePropertyEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter(PRIMARY_VIEW, this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter(PRIMARY_VIEW);
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else if (this.getParser() instanceof ISemanticParser) {
            ISemanticParser modelParser = (ISemanticParser)this.getParser();
            if (modelParser.areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        } else if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
            this.refreshLabel();
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        return new EditingFlowPage();
    }

    public void activate() {
        View eContainer = (View)this.getNotationView().eContainer();
        if (eContainer != null && eContainer.getElement() != null) {
            super.activate();
            this.addOwnerElementListeners();
            Stereotype stereotype = (Stereotype)eContainer.getElement();
            this.stereotypeApplication = StereotypeDisplayUtil.getInstance().getStereotypeApplication(this.getNotationView(), stereotype);
            Element umlElement = UMLUtil.getBaseElement((EObject)this.stereotypeApplication);
            this.getDiagramEventBroker().addNotificationListener(this.stereotypeApplication, (NotificationListener)this);
            this.getDiagramEventBroker().addNotificationListener((EObject)umlElement, (NotificationListener)this);
        }
    }

    protected void addOwnerElementListeners() {
        this.addListenerFilter(ADD_PARENT_MODEL, this, (EObject)((View)this.getParent().getModel()));
    }

    public void deactivate() {
        this.removeOwnerElementListeners();
        super.deactivate();
        if (this.stereotypeApplication != null) {
            Element umlElement = UMLUtil.getBaseElement((EObject)this.stereotypeApplication);
            this.getDiagramEventBroker().removeNotificationListener(this.stereotypeApplication, (NotificationListener)this);
            this.getDiagramEventBroker().removeNotificationListener((EObject)umlElement, (NotificationListener)this);
        }
    }

    protected void removeOwnerElementListeners() {
        this.removeListenerFilter(ADD_PARENT_MODEL);
    }

    public Object getAdapter(Class key) {
        if (key == AppliedStereotypeProperty.class) {
            return new AppliedStereotypeProperty(this.stereotypeApplication, (Property)this.resolveSemanticElement());
        }
        if (key == View.class) {
            View view = this.getNotationView();
            return view;
        }
        return null;
    }

    public static class MultilineCellEditorLocator
    implements CellEditorLocator {
        private IMultilineEditableFigure multilineEditableFigure;

        public MultilineCellEditorLocator(IMultilineEditableFigure figure) {
            this.multilineEditableFigure = figure;
        }

        public IMultilineEditableFigure getMultilineEditableFigure() {
            return this.multilineEditableFigure;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getMultilineEditableFigure().getBounds().getCopy();
            rect.x = this.getMultilineEditableFigure().getEditionLocation().x;
            rect.y = this.getMultilineEditableFigure().getEditionLocation().y;
            this.getMultilineEditableFigure().translateToAbsolute((Translatable)rect);
            if (this.getMultilineEditableFigure().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

