/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.validator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.filter.PapyrusTextMatchingMode;
import org.eclipse.papyrus.infra.nattable.filter.validator.RegexFilterDataValidator;

public class StringFilterDataValidator
implements IDataValidator {
    private RegexFilterDataValidator regexValidator = new RegexFilterDataValidator();

    public boolean validate(int columnIndex, int rowIndex, Object newValue) {
        return false;
    }

    public boolean validate(ILayerCell cell, IConfigRegistry configRegistry, Object newValue) {
        if (newValue == null) {
            return true;
        }
        Assert.isTrue((boolean)(newValue instanceof String));
        String value = (String)newValue;
        if (value.startsWith(PapyrusTextMatchingMode.NUM.getMode())) {
            String string = value.replaceFirst(PapyrusTextMatchingMode.NUM.getMode(), "");
        } else {
            if (value.startsWith(PapyrusTextMatchingMode.REGEX_FIND.getMode())) {
                String regex = value.replaceFirst(PapyrusTextMatchingMode.REGEX_FIND.getMode(), "");
                return this.regexValidator.validate(cell, configRegistry, (Object)regex);
            }
            if (value.startsWith(PapyrusTextMatchingMode.REGEX_MATCH.getMode())) {
                String regex = value.replaceFirst(PapyrusTextMatchingMode.REGEX_MATCH.getMode(), "");
                return this.regexValidator.validate(cell, configRegistry, (Object)regex);
            }
        }
        return true;
    }
}

