/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Lifeline;

public class InteractionFragmentContainerCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        IEditCommandRequest semanticCreateRequest;
        IElementType typeToCreate = (IElementType)request.getViewAndElementDescriptor().getElementAdapter().getAdapter(IElementType.class);
        if (!ElementUtil.isTypeOf((IElementType)typeToCreate, (IElementType)UMLElementTypes.LIFELINE) && (semanticCreateRequest = (IEditCommandRequest)request.getViewAndElementDescriptor().getCreateElementRequestAdapter().getAdapter(IEditCommandRequest.class)) != null) {
            Rectangle rectangle = this.getCreationRectangle(request);
            Set<Lifeline> covered = SequenceUtil.getCoveredLifelines(rectangle, this.getHost());
            RequestParameterUtils.setCoveredLifelines((IEditCommandRequest)semanticCreateRequest, covered);
        }
        return super.getCreateElementAndViewCommand(request);
    }

    protected Rectangle getCreationRectangle(CreateViewAndElementRequest request) {
        Point location = request.getLocation();
        Dimension size = request.getSize();
        if (size == null) {
            return new Rectangle(location.x(), location.y(), 1, 1);
        }
        return new Rectangle(location, size);
    }
}

