/**
 * Copyright (c) 2007, 2014 Borland Software Corporation, CEA, and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Artem Tikhomirov (Borland) - refactored javaInitilizers not to use methods from GMFGen model
 *                               [221347] Got rid of generated interfaces
 *                               (IObjectInitializer, IFeatureInitializer) and implementation thereof
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Christian W. Damus (CEA) - bug 440263
 */
package aspects.xpt.providers;

import aspects.xpt.Common;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.gmf.codegen.gmfgen.GenReferenceNewElementSpec;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class ElementInitializers_qvto extends xpt.providers.ElementInitializers_qvto {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public String javaMethodName(final GenCommonBase de, final GenFeatureValueSpec valueSpec) {
    String middlePart = "";
    GenReferenceNewElementSpec _creatingInitializer = valueSpec.getFeatureSeqInitializer().getCreatingInitializer();
    boolean _notEquals = (!Objects.equal(_creatingInitializer, null));
    if (_notEquals) {
      String _name = valueSpec.getFeatureSeqInitializer().getCreatingInitializer().getFeature().getEcoreFeature().getName();
      String _plus = (_name + "_");
      middlePart = _plus;
    }
    String _name_1 = valueSpec.getFeature().getEcoreFeature().getName();
    String _plus_1 = (_name_1 + "_");
    String _plus_2 = (_plus_1 + middlePart);
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(de);
    return (_plus_2 + _stringUniqueIdentifier);
  }
}
