/*****************************************************************************
 * Copyright (c) 2010, 2014 CEA LIST and others.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Patrick Tessier (CEA LIST) Patrick.tessier@cea.fr - Initial API and implementation
 *  Christian W. Damus (CEA) - bug 410346
 */
package org.eclipse.papyrus.uml.service.types.internal.ui.dialogs;

import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.service.types.internal.ui.messages.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * DO not modify manually, this class was generated by a visual editor
 *
 */
public class AbstractTemplateParameterConfigurationDialog extends Dialog {

	protected Object result;

	protected Shell shlTemplateparameterconfiguration;

	protected Button choosePararameteredElementButton;

	protected CLabel parameteredElementLabel;

	protected CLabel parameteredElementContent;

	protected Button chooseDefaultParameterButton;

	protected CLabel defaultElementLabel;

	protected CLabel defaultElementContent;

	protected Button btnCancel;

	protected Button btnExecute;

	/**
	 * Create the dialog.
	 *
	 * @param parent
	 * @param style
	 */
	public AbstractTemplateParameterConfigurationDialog(Shell parent, int style) {
		super(parent, SWT.DIALOG_TRIM | SWT.PRIMARY_MODAL);
		setText("SWT Dialog"); //$NON-NLS-1$
	}

	public Button getBtnCancel() {
		return btnCancel;
	}

	public Button getBtnExecute() {
		return btnExecute;
	}

	/**
	 * Open the dialog.
	 *
	 * @return the result
	 */
	public Object open() {
		createContents();
		shlTemplateparameterconfiguration.open();
		shlTemplateparameterconfiguration.layout();
		Display display = getParent().getDisplay();
		while(!shlTemplateparameterconfiguration.isDisposed()) {
			if(!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	protected void createContents() {
		Display display = Display.getCurrent();
		Rectangle rect = display.getBounds();
		shlTemplateparameterconfiguration = new Shell(getParent(), getStyle());
		shlTemplateparameterconfiguration.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		shlTemplateparameterconfiguration.setSize(426, 281);
		shlTemplateparameterconfiguration.setText(Messages.AbstractTemplateParameterConfigurationDialog_1);
		shlTemplateparameterconfiguration.setLocation(new Point(rect.x + (rect.width / 2), rect.y + (rect.height / 2) - shlTemplateparameterconfiguration.getSize().y));
		Label lblCreationOfA = new Label(shlTemplateparameterconfiguration, SWT.NONE);
		lblCreationOfA.setBackground(display.getSystemColor(SWT.COLOR_WIDGET_LIGHT_SHADOW));
		FontData[] fontdatas = { new FontData("Tahoma", 12, SWT.BOLD) }; //$NON-NLS-1$
		lblCreationOfA.setFont(Activator.getFontManager().get(fontdatas));
		lblCreationOfA.setText(Messages.AbstractTemplateParameterConfigurationDialog_3);
		lblCreationOfA.setBounds(10, 10, 408, 28);
		ExpandBar expandBarRef = new ExpandBar(shlTemplateparameterconfiguration, SWT.NONE);
		expandBarRef.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		expandBarRef.setLocation(10, 43);
		expandBarRef.setSize(408, 70);
		ExpandItem xpndtmChooseYourParamter = new ExpandItem(expandBarRef, SWT.NONE);
		xpndtmChooseYourParamter.setExpanded(true);
		xpndtmChooseYourParamter.setText(Messages.AbstractTemplateParameterConfigurationDialog_4);
		Composite composite_1 = new Composite(expandBarRef, SWT.NONE);
		composite_1.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		xpndtmChooseYourParamter.setControl(composite_1);
		choosePararameteredElementButton = new Button(composite_1, SWT.NONE);
		choosePararameteredElementButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
			}
		});
		choosePararameteredElementButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.icons", "resource/gif/Package.gif")); //$NON-NLS-1$ //$NON-NLS-2$
		choosePararameteredElementButton.setBounds(322, 10, 68, 23);
		choosePararameteredElementButton.setText("..."); //$NON-NLS-1$
		parameteredElementLabel = new CLabel(composite_1, SWT.NONE);
		parameteredElementLabel.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		parameteredElementLabel.setForeground(display.getSystemColor(SWT.COLOR_WIDGET_FOREGROUND));
		parameteredElementLabel.setBounds(10, 10, 110, 19);
		parameteredElementLabel.setText(Messages.AbstractTemplateParameterConfigurationDialog_0);
		parameteredElementContent = new CLabel(composite_1, SWT.NONE);
		parameteredElementContent.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		parameteredElementContent.setForeground(display.getSystemColor(SWT.COLOR_WIDGET_FOREGROUND));
		parameteredElementContent.setBounds(126, 10, 178, 19);
		parameteredElementContent.setText(Messages.AbstractTemplateParameterConfigurationDialog_9);
		xpndtmChooseYourParamter.setHeight(40);
		ExpandBar expandBarDefault = new ExpandBar(shlTemplateparameterconfiguration, SWT.NONE);
		expandBarDefault.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		expandBarDefault.setBounds(10, 120, 408, 70);
		ExpandItem xpndtmSetTheDefault = new ExpandItem(expandBarDefault, SWT.NONE);
		xpndtmSetTheDefault.setExpanded(true);
		xpndtmSetTheDefault.setText(Messages.AbstractTemplateParameterConfigurationDialog_10);
		Composite composite = new Composite(expandBarDefault, SWT.NONE);
		composite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		xpndtmSetTheDefault.setControl(composite);
		chooseDefaultParameterButton = new Button(composite, SWT.NONE);
		chooseDefaultParameterButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.icons", "resource/gif/Package.gif")); //$NON-NLS-1$ //$NON-NLS-2$
		chooseDefaultParameterButton.setBounds(322, 10, 68, 23);
		chooseDefaultParameterButton.setText("..."); //$NON-NLS-1$
		defaultElementLabel = new CLabel(composite, SWT.NONE);
		defaultElementLabel.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		defaultElementLabel.setForeground(display.getSystemColor(SWT.COLOR_WIDGET_FOREGROUND));
		defaultElementLabel.setBounds(10, 10, 88, 19);
		defaultElementLabel.setText(Messages.AbstractTemplateParameterConfigurationDialog_14);
		defaultElementContent = new CLabel(composite, SWT.NONE);
		defaultElementContent.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
		defaultElementContent.setForeground(display.getSystemColor(SWT.COLOR_WIDGET_FOREGROUND));
		defaultElementContent.setBounds(104, 10, 205, 19);
		defaultElementContent.setText(Messages.AbstractTemplateParameterConfigurationDialog_15);
		xpndtmSetTheDefault.setHeight(40);
		btnExecute = new Button(shlTemplateparameterconfiguration, SWT.NONE);
		btnExecute.setBounds(342, 216, 68, 23);
		btnExecute.setText(Messages.AbstractTemplateParameterConfigurationDialog_16);
		btnCancel = new Button(shlTemplateparameterconfiguration, SWT.NONE);
		btnCancel.setBounds(252, 216, 68, 23);
		btnCancel.setText(Messages.AbstractTemplateParameterConfigurationDialog_17);
	}

	/**
	 * @return the result
	 */
	public Object getResult() {
		return result;
	}

	/**
	 * @return the choosePararameteredElementButton
	 */
	public Button getChoosePararameteredElementButton() {
		return choosePararameteredElementButton;
	}

	/**
	 * @return the parameteredElementLabel
	 */
	public CLabel getParameteredElementLabel() {
		return parameteredElementLabel;
	}

	/**
	 * @return the parameteredElementContent
	 */
	public CLabel getParameteredElementContent() {
		return parameteredElementContent;
	}

	/**
	 * @return the chooseDefaultParameterButton
	 */
	public Button getChooseDefaultParameterButton() {
		return chooseDefaultParameterButton;
	}

	/**
	 * @return the defaultElementLabel
	 */
	public CLabel getDefaultElementLabel() {
		return defaultElementLabel;
	}

	/**
	 * @return the defaultElementContent
	 */
	public CLabel getDefaultElementContent() {
		return defaultElementContent;
	}
}
