/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.core.lifecycleevents;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.example.core.lifecycleevents.Activator;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;

public class LifeCycleEventsMonitorService
implements IService {
    protected ServicesRegistry servicesRegistry;
    protected ILifeCycleEventsProvider eventProvider;
    protected ISaveEventListener aboutToSaveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "event received: aboutToSaveAs"));
        }

        public void doSave(DoSaveEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "event received: aboutToSave"));
        }
    };
    protected ISaveEventListener saveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "event received: doSaveAs"));
        }

        public void doSave(DoSaveEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "event received: doSave"));
        }
    };
    protected ISaveEventListener postSaveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "event received: postSaveAs"));
        }

        public void doSave(DoSaveEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "event received: postSave"));
        }
    };

    public LifeCycleEventsMonitorService() {
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "LifeCycleEventsMonitorService created"));
    }

    public void disposeService() {
        this.deactivate();
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "LifeCycleEventsMonitorService disposed"));
    }

    public void init(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public void startService() {
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.lifecycleevents", "LifeCycleEventsMonitorService started"));
        this.activate();
    }

    private void activate() {
        try {
            this.eventProvider = (ILifeCycleEventsProvider)this.servicesRegistry.getService(ILifeCycleEventsProvider.class);
            this.eventProvider.addAboutToDoSaveListener(this.aboutToSaveListener);
            this.eventProvider.addDoSaveListener(this.saveListener);
            this.eventProvider.addPostDoSaveListener(this.postSaveListener);
        }
        catch (ServiceException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.example.core.lifecycleevents", e.getMessage()));
        }
    }

    private void deactivate() {
        this.eventProvider.removeAboutToDoSaveListener(this.aboutToSaveListener);
        this.eventProvider.removeDoSaveListener(this.saveListener);
        this.eventProvider.removePostDoSaveListener(this.postSaveListener);
    }
}

