/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.LinkLFSlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusSlidableSnapToGridAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.LinkLFNodeFigure;

public class LinkLFSVGNodePlateFigure
extends SVGNodePlateFigure {
    private static final double AVOID_DEFAULT_ANCHOR_AREA = 1.0;
    public static final String ENABLE_LINKLF = "papyrus.linklf_enable";
    private final GraphicalEditPart myHost;
    private boolean myLinkLFIsEnabled = false;

    public LinkLFSVGNodePlateFigure(GraphicalEditPart hostEP, int width, int height) {
        super(width, height);
        this.myHost = hostEP;
    }

    public LinkLFSVGNodePlateFigure withLinkLFEnabled() {
        this.myLinkLFIsEnabled = Boolean.getBoolean(ENABLE_LINKLF);
        return this;
    }

    @Override
    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (!this.myLinkLFIsEnabled) {
            return super.createAnchor(p);
        }
        if (p == null) {
            return this.createDefaultAnchor();
        }
        PapyrusSlidableSnapToGridAnchor result = this.followSVGPapyrusPath ? new PapyrusSlidableSnapToGridAnchor((NodeFigure)this, p) : new LinkLFSlidableRoundedRectangleAnchor((NodeFigure)this, p);
        result.setEditPart((EditPart)this.myHost);
        return result;
    }

    protected double getSlidableAnchorArea() {
        return this.myLinkLFIsEnabled ? 1.0 : super.getSlidableAnchorArea();
    }

    protected ConnectionAnchor createConnectionAnchor(Point p) {
        if (!this.myLinkLFIsEnabled) {
            return super.createConnectionAnchor(p);
        }
        if (p == null) {
            return this.getConnectionAnchor("");
        }
        Point temp = p.getCopy();
        this.translateToRelative((Translatable)temp);
        PrecisionPoint pt = BaseSlidableAnchor.getAnchorRelativeLocation((Point)temp, (Rectangle)this.getBounds());
        if (this.isDefaultAnchorArea(pt)) {
            return this.getConnectionAnchor("");
        }
        LinkLFNodeFigure.forceSideForBorderItemAnchorLocation((EditPart)this.myHost, (PrecisionPoint)pt);
        return this.createAnchor(pt);
    }
}

